/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.File;
import de.schlichtherle.io.FileBusyException;
import de.schlichtherle.io.ZipBusyException;
import de.schlichtherle.io.ZipController;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileOutputStream
extends FilterOutputStream {
    private static OutputStream createOutputStream(java.io.File file, boolean bl) throws FileNotFoundException {
        if (file instanceof File) {
            File file2 = (File)file;
            if (file2.isZipFile() && (file2.isDirectory() || file2.exists() && !file2.isFile())) {
                throw new FileNotFoundException(file.getPath() + ": Cannot overwrite (possibly inaccessible) ZIP compatible files!");
            }
            String string = file2.getEnclZipEntryName();
            if (string != null) {
                return FileOutputStream.createOutputStream(file2.getEnclZipFile().getZipController(), string, file2, bl);
            }
        }
        return new java.io.FileOutputStream(file, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OutputStream createOutputStream(ZipController zipController, String string, File file, boolean bl) throws FileNotFoundException {
        try {
            ZipController zipController2 = zipController;
            synchronized (zipController2) {
                OutputStream outputStream;
                InputStream inputStream = bl && zipController.getFileSystem().get(string) != null ? zipController.getInputStream(string) : null;
                try {
                    outputStream = zipController.getOutputStream(string);
                    if (inputStream != null) {
                        File.cat(inputStream, outputStream);
                    }
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                return outputStream;
            }
        }
        catch (ZipController.FalsePositiveEntryException falsePositiveEntryException) {
            return FileOutputStream.createOutputStream(zipController.enclController, File.catEntryName(zipController, string), file, bl);
        }
        catch (ZipController.FalsePositiveNativeException falsePositiveNativeException) {
            return new java.io.FileOutputStream(file);
        }
        catch (ZipBusyException zipBusyException) {
            throw new FileBusyException(file, zipBusyException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException(file.getPath());
            fileNotFoundException.initCause(iOException);
            throw fileNotFoundException;
        }
    }

    public FileOutputStream(String string) throws FileNotFoundException {
        super(FileOutputStream.createOutputStream(File.getDefaultZipDetector().createFile(string), false));
    }

    public FileOutputStream(String string, boolean bl) throws FileNotFoundException {
        super(FileOutputStream.createOutputStream(File.getDefaultZipDetector().createFile(string), bl));
    }

    public FileOutputStream(java.io.File file) throws FileNotFoundException {
        super(FileOutputStream.createOutputStream(file, false));
    }

    public FileOutputStream(java.io.File file, boolean bl) throws FileNotFoundException {
        super(FileOutputStream.createOutputStream(file, bl));
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }
}

