/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.swing;

import de.schlichtherle.io.File;
import de.schlichtherle.io.ZipDetector;
import java.io.FileFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.UIManager;

public class FileSystemView
extends javax.swing.filechooser.FileSystemView {
    private static final ResourceBundle resources = ResourceBundle.getBundle("de/schlichtherle/io/swing/FileSystemView");
    private javax.swing.filechooser.FileSystemView delegate;
    private ZipDetector zipDetector;

    public static javax.swing.filechooser.FileSystemView getFileSystemView() {
        return FileSystemView.getFileSystemView(null);
    }

    public static javax.swing.filechooser.FileSystemView getFileSystemView(ZipDetector zipDetector) {
        return new FileSystemView(javax.swing.filechooser.FileSystemView.getFileSystemView(), zipDetector);
    }

    private FileSystemView(javax.swing.filechooser.FileSystemView fileSystemView, ZipDetector zipDetector) {
        this.setDelegate(fileSystemView);
        this.setZipDetector(zipDetector);
    }

    public javax.swing.filechooser.FileSystemView getDelegate() {
        return this.delegate;
    }

    public void setDelegate(javax.swing.filechooser.FileSystemView fileSystemView) {
        this.delegate = fileSystemView;
    }

    public ZipDetector getZipDetector() {
        ZipDetector zipDetector = this.zipDetector;
        if (zipDetector != null) {
            return zipDetector;
        }
        return File.getDefaultZipDetector();
    }

    public void setZipDetector(ZipDetector zipDetector) {
        this.zipDetector = zipDetector;
    }

    protected File wrap(java.io.File file) {
        if (file == null) {
            return null;
        }
        if (file instanceof File) {
            return (File)file;
        }
        return this.getZipDetector().createFile(file);
    }

    protected java.io.File unwrap(java.io.File file) {
        if (file instanceof File) {
            return ((File)file).getDelegate();
        }
        return file;
    }

    public java.io.File createFileObject(java.io.File file) {
        if (file == null) {
            return null;
        }
        if (!this.isFileSystem(file) || this.isFileSystemRoot(file) || this.isRoot(file) || this.isComputerNode(file) || this.isDrive(file) || this.isFloppyDrive(file) || this.getDefaultDirectory().equals(this.unwrap(file))) {
            return this.unwrap(file);
        }
        return this.wrap(file);
    }

    public java.io.File createFileObject(String string) {
        return this.createFileObject(this.delegate.createFileObject(string));
    }

    public java.io.File createFileObject(java.io.File file, String string) {
        return this.createFileObject(this.delegate.createFileObject(file, string));
    }

    public java.io.File createNewFolder(java.io.File file) throws IOException {
        File file2 = this.wrap(file);
        if (file2.getInnerZipFile() != null) {
            File file3 = this.getZipDetector().createFile((java.io.File)file2, UIManager.getString(java.io.File.separatorChar == '\\' ? "FileChooser.win32.newFolder" : "FileChooser.other.newFolder"));
            int n = 2;
            while (!file3.mkdirs()) {
                if (n > 100) {
                    throw new IOException(file2 + ": Could not create new directory entry!");
                }
                file3 = this.getZipDetector().createFile((java.io.File)file2, MessageFormat.format(UIManager.getString(java.io.File.separatorChar == '\\' ? "FileChooser.win32.newFolder.subsequent" : "FileChooser.other.newFolder.subsequent"), new Integer(n)));
                ++n;
            }
            return file3;
        }
        return this.createFileObject(this.delegate.createNewFolder(this.unwrap(file)));
    }

    public java.io.File getChild(java.io.File file, String string) {
        File file2 = this.wrap(file);
        if (file2.getInnerZipFile() != null) {
            return this.createFileObject(this.delegate.getChild(file2, string));
        }
        return this.createFileObject(this.delegate.getChild(this.unwrap(file), string));
    }

    public java.io.File getDefaultDirectory() {
        return this.delegate.getDefaultDirectory();
    }

    public java.io.File[] getFiles(java.io.File file, final boolean bl) {
        File file2 = this.wrap(file);
        if (file2.getInnerZipFile() != null) {
            return file2.listFiles(new FileFilter(){

                public boolean accept(java.io.File file) {
                    return !bl || !FileSystemView.this.isHiddenFile(file);
                }
            });
        }
        java.io.File[] fileArray = this.delegate.getFiles(this.unwrap(file), bl);
        int n = fileArray.length;
        while (--n >= 0) {
            fileArray[n] = this.createFileObject(fileArray[n]);
        }
        return fileArray;
    }

    public java.io.File getHomeDirectory() {
        return this.delegate.getHomeDirectory();
    }

    public java.io.File[] getRoots() {
        return this.delegate.getRoots();
    }

    public java.io.File getParentDirectory(java.io.File file) {
        File file2 = this.wrap(file);
        if (file2.isZipEntry()) {
            return this.createFileObject(file2.getParent());
        }
        return this.createFileObject(this.delegate.getParentDirectory(this.unwrap(file)));
    }

    public String getSystemDisplayName(java.io.File file) {
        File file2 = this.wrap(file);
        if (file2.getInnerZipFile() != null) {
            return file2.getName();
        }
        return this.delegate.getSystemDisplayName(this.unwrap(file));
    }

    public Icon getSystemIcon(java.io.File file) {
        File file2 = this.wrap(file);
        if (file2.isZipFile() && ZipDetector.RAES.isZipFile(file.getPath()) && file2.isDirectory()) {
            return UIManager.getIcon("FileView.directoryIcon");
        }
        if (file2.isZipEntry()) {
            if (file2.isDirectory()) {
                return UIManager.getIcon("FileView.directoryIcon");
            }
            return UIManager.getIcon("FileView.fileIcon");
        }
        if (file.exists()) {
            return this.delegate.getSystemIcon(this.unwrap(file));
        }
        return null;
    }

    public String getSystemTypeDescription(java.io.File file) {
        File file2 = this.wrap(file);
        if (file2.isZipFile() && file2.isDirectory()) {
            return resources.getString("zipFile");
        }
        if (file2.isZipEntry()) {
            if (file2.isDirectory()) {
                return resources.getString("zipDirectoryEntry");
            }
            return resources.getString("zipFileEntry");
        }
        return this.delegate.getSystemTypeDescription(this.unwrap(file));
    }

    public boolean isComputerNode(java.io.File file) {
        return this.delegate.isComputerNode(this.unwrap(file));
    }

    public boolean isDrive(java.io.File file) {
        return this.delegate.isDrive(this.unwrap(file));
    }

    public boolean isFileSystem(java.io.File file) {
        return this.delegate.isFileSystem(this.unwrap(file));
    }

    public boolean isFileSystemRoot(java.io.File file) {
        return this.delegate.isFileSystemRoot(this.unwrap(file));
    }

    public boolean isFloppyDrive(java.io.File file) {
        return this.delegate.isFloppyDrive(this.unwrap(file));
    }

    public boolean isHiddenFile(java.io.File file) {
        return this.delegate.isHiddenFile(this.unwrap(file));
    }

    public boolean isParent(java.io.File file, java.io.File file2) {
        return this.delegate.isParent(this.wrap(file), this.wrap(file2)) || this.delegate.isParent(this.unwrap(file), this.unwrap(file2));
    }

    public boolean isRoot(java.io.File file) {
        return this.delegate.isRoot(this.unwrap(file));
    }

    public Boolean isTraversable(java.io.File file) {
        Boolean bl = this.delegate.isTraversable(this.wrap(file));
        if (Boolean.TRUE.equals(bl)) {
            return Boolean.TRUE;
        }
        Boolean bl2 = this.delegate.isTraversable(this.unwrap(file));
        if (Boolean.TRUE.equals(bl2)) {
            return Boolean.TRUE;
        }
        if (bl != null || bl2 != null) {
            return Boolean.FALSE;
        }
        return null;
    }
}

