/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.util.zip;

import de.schlichtherle.io.util.LEDataOutputStream;
import de.schlichtherle.util.zip.ZipConstants;
import de.schlichtherle.util.zip.ZipEntry;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.ZipException;

public class ZipOutputStream
extends FilterOutputStream
implements ZipConstants {
    private String comment = "";
    private short method = (short)8;
    private final Map entries = new LinkedHashMap();
    private long dataStart;
    private long cdOffset;
    private long cdLength;
    private final String encoding;
    private boolean finished;
    private boolean closed;
    private ZipEntry entry;
    private boolean deflate;
    private final CRC32 crc = new CRC32();
    private final Deflater def = new ZipDeflater();
    private final byte[] dbuf = new byte[65536];
    static final /* synthetic */ boolean $assertionsDisabled;

    public ZipOutputStream(OutputStream outputStream) throws NullPointerException {
        super(new LEDataOutputStream(outputStream));
        if (outputStream == null) {
            throw new NullPointerException("out");
        }
        this.encoding = "UTF-8";
    }

    public ZipOutputStream(OutputStream outputStream, String string) throws NullPointerException, UnsupportedEncodingException {
        super(new LEDataOutputStream(outputStream));
        if (outputStream == null) {
            throw new NullPointerException("out");
        }
        if (string == null) {
            throw new NullPointerException("encoding");
        }
        "".getBytes(string);
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public synchronized Enumeration entries() {
        return Collections.enumeration(this.entries.values());
    }

    public synchronized ZipEntry getEntry(String string) {
        return (ZipEntry)this.entries.get(string);
    }

    public synchronized void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public synchronized void setLevel(int n) {
        this.def.setLevel(n);
    }

    public int getLevel() {
        return ((ZipDeflater)this.def).getLevel();
    }

    public synchronized void setMethod(short s) {
        if (s != 0 && s != 8) {
            throw new IllegalArgumentException("Invalid compression method!");
        }
        this.method = s;
    }

    public short getMethod() {
        return this.method;
    }

    public long length() {
        return ((LEDataOutputStream)this.out).size();
    }

    public final synchronized boolean busy() {
        return this.entry != null;
    }

    public final void putNextEntry(ZipEntry zipEntry) throws IOException {
        this.putNextEntry(zipEntry, true);
    }

    public synchronized void putNextEntry(ZipEntry zipEntry, boolean bl) throws IOException {
        String string;
        this.closeEntry();
        String string2 = zipEntry.getName();
        if (zipEntry.getMethod() == -1) {
            zipEntry.setMethod(this.method);
        }
        if (zipEntry.getTime() == -1L) {
            zipEntry.setTime(System.currentTimeMillis());
        }
        int n = string2.getBytes(this.encoding).length;
        byte[] byArray = zipEntry.getExtra();
        if (byArray != null) {
            n += byArray.length;
        }
        if ((string = zipEntry.getComment()) != null) {
            n += string.getBytes(this.encoding).length;
        }
        if (n > 65535) {
            throw new ZipException("Sum of entry name, extra fields and comment too long (max 65535): " + n);
        }
        switch (zipEntry.getMethod()) {
            case 0: {
                if (zipEntry.getCrc() == -1L) {
                    throw new ZipException("CRC checksum is required for STORED method!");
                }
                if (zipEntry.getSize() == -1L) {
                    throw new ZipException("Uncompressed size is required for STORED method!");
                }
                zipEntry.setCompressedSize(zipEntry.getSize());
                this.deflate = false;
                break;
            }
            case 8: {
                if (!bl) {
                    if (zipEntry.getCrc() == -1L) {
                        throw new ZipException("CRC checksum is required for DEFLATED method when writing raw deflated data!");
                    }
                    if (zipEntry.getCompressedSize() == -1L) {
                        throw new ZipException("Compressed size is required for DEFLATED method when writing raw deflated data!");
                    }
                    if (zipEntry.getSize() == -1L) {
                        throw new ZipException("Uncompressed size is required for DEFLATED method when writing raw deflated data!");
                    }
                }
                this.deflate = bl;
                break;
            }
            default: {
                throw new ZipException("Unsupported compression method: " + zipEntry.getMethod());
            }
        }
        this.finished = false;
        this.entry = zipEntry;
        this.writeLocalFileHeader();
        ZipEntry zipEntry2 = this.entries.put(string2, zipEntry);
        if (!$assertionsDisabled && zipEntry2 != null) {
            throw new AssertionError();
        }
    }

    private void writeLocalFileHeader() throws IOException {
        boolean bl;
        ZipEntry zipEntry = this.entry;
        if (!$assertionsDisabled && zipEntry == null) {
            throw new AssertionError();
        }
        LEDataOutputStream lEDataOutputStream = (LEDataOutputStream)this.out;
        zipEntry.offset = lEDataOutputStream.size();
        lEDataOutputStream.writeInt(67324752);
        boolean bl2 = bl = zipEntry.getMethod() == 8;
        if (bl) {
            lEDataOutputStream.writeShort(20);
            lEDataOutputStream.writeShort(8);
        } else {
            lEDataOutputStream.writeShort(10);
            lEDataOutputStream.writeShort(0);
        }
        lEDataOutputStream.writeShort(zipEntry.getMethod());
        lEDataOutputStream.writeInt((int)zipEntry.getDosTime());
        if (bl) {
            lEDataOutputStream.writeInt(0);
            lEDataOutputStream.writeInt(0);
            lEDataOutputStream.writeInt(0);
        } else {
            lEDataOutputStream.writeInt((int)zipEntry.getCrc());
            lEDataOutputStream.writeInt((int)zipEntry.getCompressedSize());
            lEDataOutputStream.writeInt((int)zipEntry.getSize());
        }
        byte[] byArray = zipEntry.getName().getBytes(this.encoding);
        lEDataOutputStream.writeShort(byArray.length);
        byte[] byArray2 = zipEntry.getExtra();
        if (byArray2 == null) {
            byArray2 = new byte[]{};
        }
        lEDataOutputStream.writeShort(byArray2.length);
        lEDataOutputStream.write(byArray);
        lEDataOutputStream.write(byArray2);
        this.dataStart = lEDataOutputStream.size();
    }

    public synchronized void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.busy()) {
            if (n2 <= 0) {
                return;
            }
            if (this.deflate) {
                if (!$assertionsDisabled && this.def.finished()) {
                    throw new AssertionError();
                }
                this.def.setInput(byArray, n, n2);
                while (!this.def.needsInput()) {
                    this.deflate();
                }
                this.crc.update(byArray, n, n2);
            } else {
                this.out.write(byArray, n, n2);
                if (this.entry.getMethod() != 8) {
                    this.crc.update(byArray, n, n2);
                }
            }
        } else {
            this.out.write(byArray, n, n2);
        }
    }

    private final void ensureEntry() throws IOException {
        if (!this.busy()) {
            throw new IOException("There is no current ZIP entry to write!");
        }
    }

    private final void deflate() throws IOException {
        int n = this.def.deflate(this.dbuf, 0, this.dbuf.length);
        if (n > 0) {
            this.out.write(this.dbuf, 0, n);
        }
    }

    public synchronized void closeEntry() throws IOException {
        if (this.entry == null) {
            return;
        }
        switch (this.entry.getMethod()) {
            case 0: {
                long l = this.crc.getValue();
                if (this.entry.getCrc() != l) {
                    throw new ZipException("Bad CRC checksum for entry " + this.entry.getName() + ": " + Long.toHexString(this.entry.getCrc()) + " instead of " + Long.toHexString(l));
                }
                long l2 = ((LEDataOutputStream)this.out).size();
                if (this.entry.getSize() == l2 - this.dataStart) break;
                throw new ZipException("Bad size for entry " + this.entry.getName() + ": " + this.entry.getSize() + " instead of " + (l2 - this.dataStart));
            }
            case 8: {
                if (!this.deflate) break;
                if (!$assertionsDisabled && this.def.finished()) {
                    throw new AssertionError();
                }
                this.def.finish();
                while (!this.def.finished()) {
                    this.deflate();
                }
                this.entry.setCrc(this.crc.getValue());
                this.entry.setCompressedSize((long)this.def.getTotalOut() & 0xFFFFFFFFL);
                this.entry.setSize((long)this.def.getTotalIn() & 0xFFFFFFFFL);
                this.def.reset();
                break;
            }
            default: {
                throw new ZipException("Unsupported compression method: " + this.entry.getMethod());
            }
        }
        this.writeDataDescriptor();
        this.flush();
        this.crc.reset();
        this.entry = null;
    }

    private void writeDataDescriptor() throws IOException {
        ZipEntry zipEntry = this.entry;
        if (!$assertionsDisabled && zipEntry == null) {
            throw new AssertionError();
        }
        if (zipEntry.getMethod() == 0) {
            return;
        }
        LEDataOutputStream lEDataOutputStream = (LEDataOutputStream)this.out;
        lEDataOutputStream.writeInt(134695760);
        lEDataOutputStream.writeInt((int)zipEntry.getCrc());
        lEDataOutputStream.writeInt((int)zipEntry.getCompressedSize());
        lEDataOutputStream.writeInt((int)zipEntry.getSize());
    }

    public synchronized void finish() throws IOException {
        if (this.finished) {
            return;
        }
        this.finished = true;
        this.closeEntry();
        LEDataOutputStream lEDataOutputStream = (LEDataOutputStream)this.out;
        this.cdOffset = lEDataOutputStream.size();
        Iterator iterator = this.entries.values().iterator();
        while (iterator.hasNext()) {
            this.writeCentralFileHeader((ZipEntry)iterator.next());
        }
        this.cdLength = lEDataOutputStream.size() - this.cdOffset;
        this.writeEndOfCentralDirectory();
    }

    private void writeCentralFileHeader(ZipEntry zipEntry) throws IOException {
        if (!$assertionsDisabled && zipEntry == null) {
            throw new AssertionError();
        }
        LEDataOutputStream lEDataOutputStream = (LEDataOutputStream)this.out;
        lEDataOutputStream.writeInt(33639248);
        lEDataOutputStream.writeShort(zipEntry.getPlatform() << 8 | 0x14);
        if (zipEntry.getMethod() == 8) {
            lEDataOutputStream.writeShort(20);
            lEDataOutputStream.writeShort(8);
        } else {
            lEDataOutputStream.writeShort(10);
            lEDataOutputStream.writeShort(0);
        }
        lEDataOutputStream.writeShort(zipEntry.getMethod());
        lEDataOutputStream.writeInt((int)zipEntry.getDosTime());
        lEDataOutputStream.writeInt((int)zipEntry.getCrc());
        lEDataOutputStream.writeInt((int)zipEntry.getCompressedSize());
        lEDataOutputStream.writeInt((int)zipEntry.getSize());
        byte[] byArray = zipEntry.getName().getBytes(this.encoding);
        lEDataOutputStream.writeShort(byArray.length);
        byte[] byArray2 = zipEntry.getExtra();
        if (byArray2 == null) {
            byArray2 = new byte[]{};
        }
        lEDataOutputStream.writeShort(byArray2.length);
        String string = zipEntry.getComment();
        if (string == null) {
            string = "";
        }
        byte[] byArray3 = string.getBytes(this.encoding);
        lEDataOutputStream.writeShort(byArray3.length);
        lEDataOutputStream.writeShort(0);
        lEDataOutputStream.writeShort(0);
        lEDataOutputStream.writeInt(0);
        lEDataOutputStream.writeInt((int)zipEntry.offset);
        lEDataOutputStream.write(byArray);
        lEDataOutputStream.write(byArray2);
        lEDataOutputStream.write(byArray3);
    }

    private void writeEndOfCentralDirectory() throws IOException {
        LEDataOutputStream lEDataOutputStream = (LEDataOutputStream)this.out;
        lEDataOutputStream.writeInt(101010256);
        lEDataOutputStream.writeShort(0);
        lEDataOutputStream.writeShort(0);
        lEDataOutputStream.writeShort(this.entries.size());
        lEDataOutputStream.writeShort(this.entries.size());
        lEDataOutputStream.writeInt((int)this.cdLength);
        lEDataOutputStream.writeInt((int)this.cdOffset);
        String string = this.comment;
        if (string == null) {
            string = "";
        }
        byte[] byArray = string.getBytes(this.encoding);
        lEDataOutputStream.writeShort(byArray.length);
        lEDataOutputStream.write(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.finish();
        }
        finally {
            this.entries.clear();
            super.close();
        }
    }

    static {
        $assertionsDisabled = !ZipOutputStream.class.desiredAssertionStatus();
    }

    private static class ZipDeflater
    extends Deflater {
        private int level = -1;

        public ZipDeflater() {
            super(-1, true);
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int n) {
            super.setLevel(n);
            this.level = n;
        }
    }
}

