/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.abdera.ext.utils;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.ExtensionFactory;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Service;
import org.apache.abdera.parser.Parser;
import org.apache.chemistry.abdera.ext.CMISExtensionFactory;

public class CMISAppModel {
    private Abdera abdera = new Abdera();
    private Parser parser;
    private Factory factory = this.abdera.getFactory();

    public CMISAppModel() {
        this.factory.registerExtension((ExtensionFactory)new CMISExtensionFactory());
        this.parser = this.factory.newParser();
    }

    public Entry createEntry() {
        return this.factory.newEntry();
    }

    public Feed createFeed() {
        return this.factory.newFeed();
    }

    public Element parse(InputStream doc, String base) {
        InputStreamReader inputReader = new InputStreamReader(doc);
        return this.parse(inputReader, base);
    }

    public Element parse(Reader doc, String base) {
        Document entryDoc = base != null && base.length() > 0 ? this.parser.parse(doc, base) : this.parser.parse(doc);
        Element root = entryDoc.getRoot();
        return root;
    }

    public Service parseService(InputStream doc, String base) {
        InputStreamReader inputReader = new InputStreamReader(doc);
        return this.parseService(inputReader, base);
    }

    public Service parseService(Reader doc, String base) {
        Element root = this.parse(doc, base);
        if (!Service.class.isAssignableFrom(root.getClass())) {
            throw new RuntimeException("Bad Input. Expected APP Service, but recieved " + root.getClass());
        }
        return (Service)root;
    }

    public Entry parseEntry(InputStream doc, String base) {
        InputStreamReader inputReader = new InputStreamReader(doc);
        return this.parseEntry(inputReader, base);
    }

    public Entry parseEntry(Reader doc, String base) {
        Element root = this.parse(doc, base);
        if (!Entry.class.isAssignableFrom(root.getClass())) {
            throw new RuntimeException("Bad Input. Expected Atom Entry, but recieved " + root.getClass());
        }
        return (Entry)root;
    }

    public Feed parseFeed(InputStream doc, String base) {
        InputStreamReader inputReader = new InputStreamReader(doc);
        return this.parseFeed(inputReader, base);
    }

    public Feed parseFeed(Reader doc, String base) {
        Element root = this.parse(doc, base);
        if (!Feed.class.isAssignableFrom(root.getClass())) {
            throw new RuntimeException("Bad Input. Expected Atom Feed, but recieved " + root.getClass());
        }
        return (Feed)root;
    }
}

