/*
 * Decompiled with CFR 0.152.
 */
package marquee.xmlrpc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Stack;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import marquee.xmlrpc.XmlRpcDispatcher;
import marquee.xmlrpc.util.Log;
import marquee.xmlrpc.util.ServerInputStream;
import marquee.xmlrpc.util.Trace;

public class XmlRpcServerConnection
extends Thread {
    public static final byte[] OK = "HTTP/1.1 200 OK\r\n".getBytes();
    public static final byte[] ERROR = "HTTP/1.1 400 Internal Error\r\n".getBytes();
    public static final byte[] SERVER = "Server: Marquee XML-RPC 1.3\r\n".getBytes();
    public static final byte[] CLOSE_CONNECTION = "Connection: close\r\n".getBytes();
    public static final byte[] KEEP_CONNECTION = "Connection: keep-alive\r\n".getBytes();
    public static final byte[] CONTENT_TYPE = "Content-Type: text/xml\r\n".getBytes();
    public static final byte[] GZIP_ENCODING = "Content-Encoding: gzip\r\n".getBytes();
    public static final byte[] CONTENT_LENGTH = "Content-Length: ".getBytes();
    public static final byte[] CRLF = "\r\n\r\n".getBytes();
    private static final Stack connections = new Stack();
    private static int poolLimit = 10;
    private static int connectionLimit = 10;
    private static int connectionCount = 0;
    private XmlRpcDispatcher dispatcher;
    private Socket socket;
    private final byte[] httpBuffer = new byte[256];
    static Class class$marquee$xmlrpc$XmlRpcServerConnection;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized XmlRpcServerConnection getConnection(XmlRpcDispatcher dispatcher) {
        XmlRpcServerConnection conn;
        if (connections.empty()) {
            if (connectionCount >= connectionLimit) return null;
            if (Trace.Debugs) {
                Log.append(Trace.Debug, "Instantiating new XmlRpcServerConnection thread.");
            }
            conn = new XmlRpcServerConnection();
            conn.start();
            ++connectionCount;
        } else {
            if (Trace.Debugs) {
                Log.append(Trace.Debug, "Acquiring XmlRpcServerConnection thread from pool.");
            }
            conn = (XmlRpcServerConnection)connections.pop();
        }
        conn.dispatcher = dispatcher;
        return conn;
    }

    public static synchronized void setLimits(int connectionLimit, int poolLimit) {
        if (connectionLimit > 0) {
            XmlRpcServerConnection.connectionLimit = connectionLimit;
            XmlRpcServerConnection.poolLimit = poolLimit <= connectionLimit ? poolLimit : connectionLimit;
        }
    }

    public XmlRpcServerConnection() {
        super("XmlRpcServerConnection-".concat(String.valueOf(String.valueOf(connectionCount))));
    }

    public synchronized void handleConnection(Socket socket) {
        this.socket = socket;
        this.notify();
    }

    public void run() {
        while (true) {
            block22: {
                BufferedOutputStream bos;
                BufferedInputStream bis;
                block21: {
                    if (!this.acquireSocket()) {
                        return;
                    }
                    if (Trace.Messages) {
                        Log.append(Trace.Message, "Connection activated, serving ".concat(String.valueOf(String.valueOf(this.socket.getInetAddress().getHostAddress()))));
                    }
                    bis = null;
                    bos = null;
                    try {
                        boolean keepAlive;
                        bis = new BufferedInputStream(this.socket.getInputStream());
                        bos = new BufferedOutputStream(this.socket.getOutputStream());
                        do {
                            byte[] result;
                            boolean isZipped;
                            block20: {
                                keepAlive = false;
                                isZipped = false;
                                int contentLength = -1;
                                result = null;
                                String header = XmlRpcServerConnection.readHttpHeader(bis, this.httpBuffer);
                                if (header.startsWith("post")) {
                                    while (!(header = XmlRpcServerConnection.readHttpHeader(bis, this.httpBuffer)).equals("")) {
                                        if (header.startsWith("connection")) {
                                            keepAlive = header.equals("connection: keep-alive");
                                            continue;
                                        }
                                        if (header.startsWith("content-length")) {
                                            contentLength = Integer.parseInt(header.substring(16));
                                            continue;
                                        }
                                        if (!header.startsWith("accept-encoding")) continue;
                                        isZipped = header.equals("accept-encoding: gzip");
                                    }
                                    try {
                                        result = this.dispatcher.dispatch(isZipped ? new GZIPInputStream(new ServerInputStream(bis, contentLength)) : new ServerInputStream(bis, contentLength));
                                    }
                                    catch (Throwable t) {
                                        if (!Trace.Errors) break block20;
                                        Log.append(Trace.Error, t);
                                    }
                                }
                            }
                            if (result != null) {
                                if (isZipped) {
                                    bos.write(OK);
                                    bos.write(SERVER);
                                    bos.write(CONTENT_TYPE);
                                    bos.write(GZIP_ENCODING);
                                    bos.write(keepAlive ? KEEP_CONNECTION : CLOSE_CONNECTION);
                                    bos.write(CONTENT_LENGTH);
                                    bos.write(Integer.toString(result.length).getBytes());
                                    bos.write(CRLF);
                                    GZIPOutputStream zip = new GZIPOutputStream(bos);
                                    zip.write(result);
                                    zip.finish();
                                    ((FilterOutputStream)zip).flush();
                                    continue;
                                }
                                bos.write(OK);
                                bos.write(SERVER);
                                bos.write(CONTENT_TYPE);
                                bos.write(keepAlive ? KEEP_CONNECTION : CLOSE_CONNECTION);
                                bos.write(CONTENT_LENGTH);
                                bos.write(Integer.toString(result.length).getBytes());
                                bos.write(CRLF);
                                bos.write(result);
                                bos.flush();
                                continue;
                            }
                            bos.write(ERROR);
                            bos.flush();
                        } while (keepAlive);
                    }
                    catch (Exception e) {
                        if (!Trace.Errors) break block21;
                        Log.append(Trace.Error, e);
                    }
                }
                this.dispatcher.release();
                this.dispatcher = null;
                try {
                    bis.close();
                    bos.close();
                    this.socket.close();
                }
                catch (IOException e) {
                    if (!Trace.Errors) break block22;
                    Log.append(Trace.Error, e);
                }
            }
            this.socket = null;
            Class clazz = class$marquee$xmlrpc$XmlRpcServerConnection == null ? XmlRpcServerConnection.class$("marquee.xmlrpc.XmlRpcServerConnection") : class$marquee$xmlrpc$XmlRpcServerConnection;
            synchronized (clazz) {
                if (connections.size() >= poolLimit) {
                    --connectionCount;
                    return;
                }
                connections.push(this);
            }
        }
    }

    public static String readHttpHeader(InputStream is, byte[] httpBuffer) throws IOException {
        byte val;
        int pos = 0;
        while ((val = (byte)is.read()) > -1) {
            if (val == 13) {
                is.read();
                return new String(httpBuffer, 0, pos);
            }
            if (val > 64 && val < 91) {
                val = (byte)(val + 32);
            }
            if (pos >= httpBuffer.length) continue;
            httpBuffer[pos++] = val;
        }
        return null;
    }

    private synchronized boolean acquireSocket() {
        while (this.socket == null) {
            try {
                XmlRpcServerConnection xmlRpcServerConnection = this;
                synchronized (xmlRpcServerConnection) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                Class clazz = class$marquee$xmlrpc$XmlRpcServerConnection == null ? (class$marquee$xmlrpc$XmlRpcServerConnection = XmlRpcServerConnection.class$("marquee.xmlrpc.XmlRpcServerConnection")) : class$marquee$xmlrpc$XmlRpcServerConnection;
                synchronized (clazz) {
                    --connectionCount;
                }
                if (this.socket != null) {
                    block12: {
                        try {
                            this.socket.close();
                        }
                        catch (IOException ioe) {
                            if (!Trace.Errors) break block12;
                            Log.append(Trace.Error, "Connection thread was interrupted.");
                        }
                    }
                    this.socket = null;
                }
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

