/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.command.AbstractBaseCommand;
import org.jbpm.command.GetProcessInstancesCommand;
import org.jbpm.graph.exe.ProcessInstance;

public abstract class AbstractProcessInstanceBaseCommand
extends AbstractBaseCommand {
    protected Log log = LogFactory.getLog(this.getClass());
    private long[] processInstanceIds = null;
    private String processName = null;
    private int processVersion = 0;
    private boolean onlyRunning = true;
    private boolean operateOnSingleObject;
    private transient JbpmContext jbpmContext;

    protected JbpmContext getJbpmContext() {
        return this.jbpmContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(JbpmContext jbpmContext) throws Exception {
        ArrayList<ProcessInstance> result = new ArrayList<ProcessInstance>();
        this.jbpmContext = jbpmContext;
        try {
            this.log.debug((Object)("executing " + this));
            if (this.processInstanceIds != null && this.processInstanceIds.length > 0) {
                for (int i = 0; i < this.processInstanceIds.length; ++i) {
                    ProcessInstance pi = jbpmContext.loadProcessInstanceForUpdate(this.processInstanceIds[i]);
                    result.add(this.execute(pi));
                }
            }
            if (this.processName != null) {
                this.operateOnSingleObject = false;
                GetProcessInstancesCommand cmd = new GetProcessInstancesCommand();
                cmd.setProcessName(this.processName);
                cmd.setOnlyRunning(this.onlyRunning);
                if (this.processVersion > 0) {
                    cmd.setVersion(String.valueOf(this.processVersion));
                }
                List processInstanceList = (List)cmd.execute(jbpmContext);
                for (ProcessInstance pi : processInstanceList) {
                    this.execute(pi);
                }
            }
            if (this.operateOnSingleObject) {
                if (result.size() < 1) {
                    Object var3_5 = null;
                    return var3_5;
                }
                Object e = result.get(0);
                return e;
            }
            ArrayList<ProcessInstance> arrayList = result;
            return arrayList;
        }
        finally {
            this.jbpmContext = null;
        }
    }

    public abstract ProcessInstance execute(ProcessInstance var1);

    public void setProcessInstanceIds(long[] processInstanceIds) {
        this.operateOnSingleObject = false;
        this.processInstanceIds = processInstanceIds;
    }

    public void setProcessInstanceId(long processInstanceId) {
        this.operateOnSingleObject = true;
        this.processInstanceIds = new long[1];
        this.processInstanceIds[0] = processInstanceId;
    }

    public String toString() {
        if (this.processName != null) {
            return this.getClass().getName() + " [tokenIds=" + Arrays.toString(this.processInstanceIds) + ";processName=" + this.processName + ";processVersion=" + (this.processVersion > 0 ? Integer.valueOf(this.processVersion) : "NA") + this.getAdditionalToStringInformation() + "]";
        }
        return this.getClass().getName() + " [tokenIds=" + Arrays.toString(this.processInstanceIds) + ";operateOnSingleObject=" + this.operateOnSingleObject + this.getAdditionalToStringInformation() + "]";
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public int getProcessVersion() {
        return this.processVersion;
    }

    public void setProcessVersion(int processVersion) {
        this.processVersion = processVersion;
    }

    public long[] getProcessInstanceIds() {
        return this.processInstanceIds;
    }

    public long getProcessInstanceId() {
        if (this.processInstanceIds == null || this.processInstanceIds.length != 1) {
            throw new IllegalStateException("getProcessInstanceId can only be called if only one process instance id is set on command " + this + " but was " + this.processInstanceIds);
        }
        return this.processInstanceIds[0];
    }

    public boolean isOnlyRunning() {
        return this.onlyRunning;
    }

    public void setOnlyRunning(boolean onlyRunning) {
        this.onlyRunning = onlyRunning;
    }

    public AbstractProcessInstanceBaseCommand processInstanceIds(long[] processInstanceIds) {
        this.setProcessInstanceIds(processInstanceIds);
        return this;
    }

    public AbstractProcessInstanceBaseCommand processInstanceId(long processInstanceId) {
        this.setProcessInstanceId(processInstanceId);
        return this;
    }

    public AbstractProcessInstanceBaseCommand processName(String processName) {
        this.setProcessName(processName);
        return this;
    }

    public AbstractProcessInstanceBaseCommand processVersion(int processVersion) {
        this.setProcessVersion(processVersion);
        return this;
    }

    public AbstractProcessInstanceBaseCommand onlyRunning(boolean onlyRunning) {
        this.setOnlyRunning(onlyRunning);
        return this;
    }
}

