/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem.server;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.StringBufferInputStream;
import thredds.filesystem.MDirectory;
import thredds.filesystem.Manager;
import thredds.filesystem.server.AccessLogParser;
import thredds.filesystem.server.LogReader;
import thredds.filesystem.server.PathMatcher;
import ucar.unidata.util.StringUtil;

public class TestFileSystem {
    static String prefix = "/thredds/catalog/";
    private static String roots = "terminal/level3/IDD,/data/ldm/pub/native/radar/level3/\nterminal/level3,/data/ldm/pub/native/radar/level3/\nstation/soundings,/data/ldm/pub/native/profiler/bufr/profiler3/\nstation/profiler/wind/1hr,/data/ldm/pub/native/profiler/wind/01hr/\nstation/profiler/wind/06min,/data/ldm/pub/native/profiler/wind/06min/\nstation/profiler/RASS/1hr,/data/ldm/pub/native/profiler/RASS/01hr/\nstation/profiler/RASS/06min,/data/ldm/pub/native/profiler/RASS/06min/\nstation/metar,/data/ldm/pub/decoded/netcdf/surface/metar/\nsatellite/WV,/data/ldm/pub/native/satellite/WV/\nsatellite/VIS,/data/ldm/pub/native/satellite/VIS/\nsatellite/SOUND-VIS,/data/ldm/pub/native/satellite/SOUND-VIS/\nsatellite/SOUND-7.43,/data/ldm/pub/native/satellite/SOUND-7.43/\nsatellite/SOUND-7.02,/data/ldm/pub/native/satellite/SOUND-7.02/\nsatellite/SOUND-6.51,/data/ldm/pub/native/satellite/SOUND-6.51/\nsatellite/SOUND-4.45,/data/ldm/pub/native/satellite/SOUND-4.45/\nsatellite/SOUND-3.98,/data/ldm/pub/native/satellite/SOUND-3.98/\nsatellite/SOUND-14.06,/data/ldm/pub/native/satellite/SOUND-14.06/\nsatellite/SOUND-11.03,/data/ldm/pub/native/satellite/SOUND-11.03/\nsatellite/SFC-T/SUPER-NATIONAL_1km,/data/ldm/pub/native/satellite/SFC-T/SUPER-NATIONAL_1km/\nsatellite/PW,/data/ldm/pub/native/satellite/PW/\nsatellite/LI,/data/ldm/pub/native/satellite/LI/\nsatellite/IR,/data/ldm/pub/native/satellite/IR/\nsatellite/CTP,/data/ldm/pub/native/satellite/CTP/\nsatellite/3.9/WEST-CONUS_4km,/data/ldm/pub/native/satellite/3.9/WEST-CONUS_4km/\nsatellite/3.9/PR-REGIONAL_4km,/data/ldm/pub/native/satellite/3.9/PR-REGIONAL_4km/\nsatellite/3.9/HI-REGIONAL_4km,/data/ldm/pub/native/satellite/3.9/HI-REGIONAL_4km/\nsatellite/3.9/EAST-CONUS_4km,/data/ldm/pub/native/satellite/3.9/EAST-CONUS_4km/\nsatellite/3.9/AK-REGIONAL_8km,/data/ldm/pub/native/satellite/3.9/AK-REGIONAL_8km/\nsatellite/13.3,/data/ldm/pub/native/satellite/13.3/\nsatellite/12.0,/data/ldm/pub/native/satellite/12.0/\nrestrict,/opt/tds-test/content/thredds/public/\nnexrad/level3/IDD,/data/ldm/pub/native/radar/level3/\nnexrad/level3/CCS039,/data/ldm/pub/casestudies/ccs039/images/radar/nids\nnexrad/level3,/data/ldm/pub/native/radar/level3/\nnexrad/level2/IDD,/data/ldm/pub/native/radar/level2\nnexrad/level2/CCS039,/data/ldm/pub/casestudies/ccs039/images/radar/level2\nnexrad/level2,/data/ldm/pub/native/radar/level2/\nnexrad/composite/nws,/data/ldm/pub/native/radar/10km_mosaic/\nnexrad/composite/gini,/data/ldm/pub/native/radar/composite/gini/\nnexrad/composite/1km/files,/data/ldm/pub/native/radar/composite/grib2/\nmodelsNc/NCEP/SST/Global_5x2p5deg,/data/ldm/pub/decoded/netcdf/grid/NCEP/SST/Global_5x2p5deg/\nmodelsNc/NCEP/SST/Global_2x2deg,/data/ldm/pub/decoded/netcdf/grid/NCEP/SST/Global_2x2deg/\nmodelsNc/NCEP/RUC2/CONUS_40km,/data/ldm/pub/decoded/netcdf/grid/NCEP/RUC2/CONUS_40km/\nmodelsNc/NCEP/RUC/CONUS_80km,/data/ldm/pub/decoded/netcdf/grid/NCEP/RUC/CONUS_80km/\nmodelsNc/NCEP/OCEAN/Global_5x2p5deg,/data/ldm/pub/decoded/netcdf/grid/NCEP/OCEAN/Global_5x2p5deg/\nmodelsNc/NCEP/NAM/CONUS_80km,/data/ldm/pub/decoded/netcdf/grid/NCEP/NAM/CONUS_80km/\nmodelsNc/NCEP/GFS/Global_5x2p5deg,/data/ldm/pub/decoded/netcdf/grid/NCEP/GFS/Global_5x2p5deg/\nmodelsNc/NCEP/GFS/Extended_Global_5p0deg,/data/ldm/pub/decoded/netcdf/grid/NCEP/GFS/Extended_Global_5p0deg/\nmodelsNc/NCEP/GFS/CONUS_80km,/data/ldm/pub/decoded/netcdf/grid/NCEP/GFS/CONUS_80km/\nmodel/NCEP/RUC2/CONUS_20km/surface,/data/ldm/pub/native/grid/NCEP/RUC2/CONUS_20km/surface/\nmodel/NCEP/RUC2/CONUS_20km/pressure,/data/ldm/pub/native/grid/NCEP/RUC2/CONUS_20km/pressure/\nmodel/NCEP/RUC2/CONUS_20km/hybrid,/data/ldm/pub/native/grid/NCEP/RUC2/CONUS_20km/hybrid/\nmodel/NCEP/RUC/CONUS_80km,/data/ldm/pub/native/grid/NCEP/RUC/CONUS_80km/\nmodel/NCEP/NDFD/CONUS_5km,/data/ldm/pub/native/grid/NCEP/NDFD/CONUS_5km/\nmodel/NCEP/NAM/Polar_90km,/data/ldm/pub/native/grid/NCEP/NAM/Polar_90km/\nmodel/NCEP/NAM/CONUS_80km,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_80km/\nmodel/NCEP/NAM/CONUS_40km/conduit,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_40km/conduit/\nmodel/NCEP/NAM/CONUS_20km/surface,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_20km/surface/\nmodel/NCEP/NAM/CONUS_20km/selectsurface,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_20km/selectsurface/\nmodel/NCEP/NAM/CONUS_20km/noaaport,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_20km/noaaport/\nmodel/NCEP/NAM/CONUS_12km,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_12km/\nmodel/NCEP/NAM/Alaska_95km,/data/ldm/pub/native/grid/NCEP/NAM/Alaska_95km/\nmodel/NCEP/NAM/Alaska_45km/noaaport,/data/ldm/pub/native/grid/NCEP/NAM/Alaska_45km/noaaport/\nmodel/NCEP/NAM/Alaska_45km/conduit,/data/ldm/pub/native/grid/NCEP/NAM/Alaska_45km/conduit/\nmodel/NCEP/NAM/Alaska_22km,/data/ldm/pub/native/grid/NCEP/NAM/Alaska_22km/\nmodel/NCEP/NAM/Alaska_11km,/data/ldm/pub/native/grid/NCEP/NAM/Alaska_11km/\nmodel/NCEP/GFS/Puerto_Rico_191km,/data/ldm/pub/native/grid/NCEP/GFS/Puerto_Rico_191km/\nmodel/NCEP/GFS/N_Hemisphere_381km,/data/ldm/pub/native/grid/NCEP/GFS/N_Hemisphere_381km/\nmodel/NCEP/GFS/Hawaii_160km,/data/ldm/pub/native/grid/NCEP/GFS/Hawaii_160km/\nmodel/NCEP/GFS/Global_onedeg,/data/ldm/pub/native/grid/NCEP/GFS/Global_onedeg/\nmodel/NCEP/GFS/Global_2p5deg,/data/ldm/pub/native/grid/NCEP/GFS/Global_2p5deg/\nmodel/NCEP/GFS/Global_0p5deg,/data/ldm/pub/native/grid/NCEP/GFS/Global_0p5deg/\nmodel/NCEP/GFS/CONUS_95km,/data/ldm/pub/native/grid/NCEP/GFS/CONUS_95km/\nmodel/NCEP/GFS/CONUS_80km,/data/ldm/pub/native/grid/NCEP/GFS/CONUS_80km/\nmodel/NCEP/GFS/CONUS_191km,/data/ldm/pub/native/grid/NCEP/GFS/CONUS_191km/\nmodel/NCEP/GFS/Alaska_191km,/data/ldm/pub/native/grid/NCEP/GFS/Alaska_191km/\nmodel/NCEP/DGEX/CONUS_12km,/data/ldm/pub/native/grid/NCEP/DGEX/CONUS_12km/\nmodel/NCEP/DGEX/Alaska_12km,/data/ldm/pub/native/grid/NCEP/DGEX/Alaska_12km/\ngis/test,/data/thredds/gis/\ngaleon/testdata,/data/thredds/galeon/\ngaleon/ndfd/testdata,/data/ldm/pub/native/grid/NCEP/NDFD/CONUS_5km/\ngaleon/global/testdata,/data/ldm/pub/native/grid/NCEP/GFS/Global_0p5deg/\nfmrc/Unidata/rtmodel/nmm/files,/data/ldm/pub/rtmodel/\nfmrc/Unidata/rtmodel/nmm-alt/files,/data/ldm/pub/rtmodel/\nfmrc/NCEP/SREF/CONUS_40km/pgrb_biasc,/data/ldm/pub/native/grid/NCEP/SREF/CONUS_40km/pgrb_biasc/\nfmrc/NCEP/SREF/CONUS_40km/ensprod_biasc,/data/ldm/pub/native/grid/NCEP/SREF/CONUS_40km/ensprod_biasc/\nfmrc/NCEP/RUC2/CONUS_40km,/data/ldm/pub/native/grid/NCEP/RUC2/CONUS_40km/\nfmrc/NCEP/RUC2/CONUS_20km/surface,/data/ldm/pub/native/grid/NCEP/RUC2/CONUS_20km/surface/\nfmrc/NCEP/RUC2/CONUS_20km/pressure,/data/ldm/pub/native/grid/NCEP/RUC2/CONUS_20km/pressure/\nfmrc/NCEP/RUC2/CONUS_20km/hybrid,/data/ldm/pub/native/grid/NCEP/RUC2/CONUS_20km/hybrid/\nfmrc/NCEP/RUC/CONUS_80km,/data/ldm/pub/native/grid/NCEP/RUC/CONUS_80km/\nfmrc/NCEP/NEWGBXNDFD/CONUS_5km,/data/ldm/pub/native/grid/NCEP/NEWGBXNDFD/CONUS_5km/\nfmrc/NCEP/NDFD/CONUS_5km,/data/ldm/pub/native/grid/NCEP/NDFD/CONUS_5km/\nfmrc/NCEP/NAM/Polar_90km,/data/ldm/pub/native/grid/NCEP/NAM/Polar_90km/\nfmrc/NCEP/NAM/CONUS_80km,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_80km/\nfmrc/NCEP/NAM/CONUS_40km/conduit,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_40km/conduit/\nfmrc/NCEP/NAM/CONUS_20km/surface,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_20km/surface/\nfmrc/NCEP/NAM/CONUS_20km/selectsurface,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_20km/selectsurface/\nfmrc/NCEP/NAM/CONUS_20km/noaaport,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_20km/noaaport/\nfmrc/NCEP/NAM/CONUS_12km/conduit,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_12km_conduit/\nfmrc/NCEP/NAM/CONUS_12km,/data/ldm/pub/native/grid/NCEP/NAM/CONUS_12km/\nfmrc/NCEP/NAM/Alaska_95km,/data/ldm/pub/native/grid/NCEP/NAM/Alaska_95km/\nfmrc/NCEP/NAM/Alaska_45km/noaaport,/data/ldm/pub/native/grid/NCEP/NAM/Alaska_45km/noaaport/\nfmrc/NCEP/NAM/Alaska_45km/conduit,/data/ldm/pub/native/grid/NCEP/NAM/Alaska_45km/conduit/\nfmrc/NCEP/NAM/Alaska_22km,/data/ldm/pub/native/grid/NCEP/NAM/Alaska_22km/\nfmrc/NCEP/NAM/Alaska_11km,/data/ldm/pub/native/grid/NCEP/NAM/Alaska_11km/\nfmrc/NCEP/GFS/Puerto_Rico_191km,/data/ldm/pub/native/grid/NCEP/GFS/Puerto_Rico_191km/\nfmrc/NCEP/GFS/N_Hemisphere_381km,/data/ldm/pub/native/grid/NCEP/GFS/N_Hemisphere_381km/\nfmrc/NCEP/GFS/Hawaii_160km,/data/ldm/pub/native/grid/NCEP/GFS/Hawaii_160km/\nfmrc/NCEP/GFS/Global_onedeg,/data/ldm/pub/native/grid/NCEP/GFS/Global_onedeg/\nfmrc/NCEP/GFS/Global_2p5deg,/data/ldm/pub/native/grid/NCEP/GFS/Global_2p5deg/\nfmrc/NCEP/GFS/Global_1p0deg_Ensemble,/data/ldm/pub/native/grid/NCEP/GFS/Global_1p0deg_Ensemble/\nfmrc/NCEP/GFS/Global_0p5deg,/data/ldm/pub/native/grid/NCEP/GFS/Global_0p5deg/\nfmrc/NCEP/GFS/CONUS_95km,/data/ldm/pub/native/grid/NCEP/GFS/CONUS_95km/\nfmrc/NCEP/GFS/CONUS_80km,/data/ldm/pub/native/grid/NCEP/GFS/CONUS_80km/\nfmrc/NCEP/GFS/CONUS_191km,/data/ldm/pub/native/grid/NCEP/GFS/CONUS_191km/\nfmrc/NCEP/GFS/Alaska_191km,/data/ldm/pub/native/grid/NCEP/GFS/Alaska_191km/\nfmrc/NCEP/DGEX/CONUS_12km,/data/ldm/pub/native/grid/NCEP/DGEX/CONUS_12km/\nfmrc/NCEP/DGEX/Alaska_12km,/data/ldm/pub/native/grid/NCEP/DGEX/Alaska_12km/\ncasestudies/vgee_demo,/data/ldm/pub/casestudies/vgee_demo\ncasestudies/july18_2002/grids,/data/ldm/pub/casestudies/july18_2002/grids\ncasestudies/idvtest/grids,/data/ldm/pub/casestudies/idvtest/grids\ncasestudies/ccs039/grids,/data/ldm/pub/casestudies/ccs039/grids\ncasestudies/ccs034/netcdf,/data/ldm/pub/casestudies/ccs034/netcdf\ncasestudies/ccs034/grib,/data/ldm/pub/casestudies/ccs034/grib\ncasestudies/ccs034/acars,/data/ldm/pub/casestudies/ccs034/acars\nGEMPAK/model,/data/ldm/pub/decoded/gempak/model";
    private static PathMatcher pathMatcher = null;
    public static String[] services = new String[]{"catalog", "dodsC", "dqc", "fileServer", "ncss/grid", "ncss/metars", "radarServer", "remoteCatalogService", "view", "wcs", "wms"};
    int datasetReq = 0;
    int unknownReq = 0;
    int latestReq = 0;
    private static String ehLocation = "/data/thredds/ehcache/";
    private static String config = "<ehcache>\n    <diskStore path='" + ehLocation + "'/>\n" + "    <defaultCache\n" + "              maxElementsInMemory='10000'\n" + "              eternal='false'\n" + "              timeToIdleSeconds='120'\n" + "              timeToLiveSeconds='120'\n" + "              overflowToDisk='true'\n" + "              maxElementsOnDisk='10000000'\n" + "              diskPersistent='false'\n" + "              diskExpiryThreadIntervalSeconds='120'\n" + "              memoryStoreEvictionPolicy='LRU'\n" + "              />\n" + "    <cache name='directory'\n" + "            maxElementsInMemory='1000'\n" + "            eternal='false'\n" + "            timeToIdleSeconds='864000'\n" + "            timeToLiveSeconds='0'\n" + "            overflowToDisk='true'\n" + "            maxElementsOnDisk='0'\n" + "            diskPersistent='true'\n" + "            diskExpiryThreadIntervalSeconds='3600'\n" + "            memoryStoreEvictionPolicy='LRU'\n" + "            />\n" + "</ehcache>";
    Manager manager = nocache ? new Manager() : new Manager(new StringBufferInputStream(config));
    static boolean showRoots = false;
    static boolean show = false;
    static boolean nocache = false;

    public static String[] getRoots() {
        String rootString = StringUtil.replace(roots, "\n", ",");
        String[] root2 = rootString.split(",");
        String[] result = new String[root2.length / 2];
        for (int i = 0; i < root2.length; i += 2) {
            result[i / 2] = root2[i];
        }
        return result;
    }

    public static PathMatcher readRoots() {
        PathMatcher pathMatcher = new PathMatcher();
        String rootString = StringUtil.replace(roots, "\n", ",");
        String[] roots = rootString.split(",");
        for (int i = 0; i < roots.length; i += 2) {
            if (showRoots) {
                System.out.printf("  %-40s %-40s%n", roots[i], roots[i + 1]);
            }
            pathMatcher.put(roots[i], roots[i + 1]);
        }
        return pathMatcher;
    }

    public static String getDataroot(String path) {
        if (pathMatcher == null) {
            pathMatcher = TestFileSystem.readRoots();
        }
        String dataRoot = null;
        if (path.startsWith("/dqcServlet")) {
            dataRoot = "dqcServlet";
        } else if (!path.startsWith("/thredds/")) {
            dataRoot = "root";
        } else {
            String service = TestFileSystem.findService(path = path.substring(9));
            if (service != null) {
                PathMatcher.Match match;
                if (service.equals("radarServer")) {
                    dataRoot = "radarServer";
                } else if (service.equals("dqc")) {
                    dataRoot = "dqc";
                } else if (path.length() > service.length() && (match = pathMatcher.match(path = path.substring(service.length() + 1))) != null) {
                    dataRoot = match.root;
                }
            }
            if (dataRoot == null && (path.endsWith("xml") || path.endsWith("html"))) {
                dataRoot = "catalog";
            }
            if (dataRoot == null) {
                dataRoot = "misc";
            }
        }
        return dataRoot;
    }

    public static String getService(String path) {
        String service = null;
        if (path.startsWith("/thredds/")) {
            String req;
            int pos;
            service = TestFileSystem.findService(path = path.substring(9));
            if (service == null && (path.endsWith("xml") || path.endsWith("html"))) {
                service = "catalog";
            }
            if (service == null && (pos = path.indexOf(63)) > 0 && ((req = path.substring(0, pos)).endsWith("xml") || req.endsWith("html"))) {
                service = "catalog";
            }
        }
        if (service == null) {
            service = "unknown";
        }
        return service;
    }

    public static String findService(String path) {
        for (String service : services) {
            if (!path.startsWith(service)) continue;
            return service;
        }
        return null;
    }

    TestFileSystem() {
        System.out.printf(" Ehcache at %s%n", ehLocation);
        if (pathMatcher == null) {
            pathMatcher = TestFileSystem.readRoots();
        }
    }

    void process(String logDir) throws IOException {
        LogReader reader = new LogReader(new AccessLogParser());
        long startElapsed = System.nanoTime();
        LogReader.Stats stats = new LogReader.Stats();
        reader.readAll(new File(logDir), new MyFF(), new MyClosure(), new MyLogFilter(), stats);
        long elapsedTime = System.nanoTime() - startElapsed;
        System.out.printf(" total= %d passed=%d%n", stats.total, stats.passed);
        System.out.printf(" elapsed=%f msecs %n", (double)elapsedTime / 1000000.0);
    }

    void close() {
        this.manager.stats();
        this.manager.close();
    }

    public static void main(String[] args) throws IOException {
        System.out.printf("TestFileSystem%n", new Object[0]);
        if (args.length < 1) {
            System.out.printf("usage: thredds.filesystem.server.TestFileSystem logDir [show] [showRoots] [nocache]%n", new Object[0]);
        }
        String path = args[0];
        for (String arg : args) {
            if (arg.equals("show")) {
                show = true;
            }
            if (arg.equals("showRoots")) {
                showRoots = true;
            }
            if (!arg.equals("nocache")) continue;
            nocache = true;
        }
        TestFileSystem reader = new TestFileSystem();
        System.out.printf(" Reading logs from %s%n", path);
        reader.process(path);
        System.out.printf("   latestReq= %d%n", reader.latestReq);
        System.out.printf("   datasetReq= %d%n", reader.datasetReq);
        System.out.printf("   unknownReq= %d%n", reader.unknownReq);
        reader.close();
    }

    class MyClosure
    implements LogReader.Closure {
        MyClosure() {
        }

        public void process(LogReader.Log log) {
            String dirName;
            MDirectory mdir;
            String path = log.path.substring(prefix.length());
            int len = 0;
            if (path.endsWith("/catalog.xml")) {
                len = "/catalog.xml".length();
            } else if (path.endsWith("/catalog.html")) {
                len = "/catalog.html".length();
            } else if (path.endsWith("/latest.xml")) {
                ++TestFileSystem.this.latestReq;
                len = "/latest.xml".length();
            } else if (path.endsWith("/latest.html")) {
                ++TestFileSystem.this.latestReq;
                len = "/latest.html".length();
            } else {
                if (path.contains("catalog.html?dataset=")) {
                    ++TestFileSystem.this.datasetReq;
                    return;
                }
                if (path.contains("latest.html?dataset=")) {
                    ++TestFileSystem.this.datasetReq;
                    return;
                }
                ++TestFileSystem.this.unknownReq;
                return;
            }
            PathMatcher.Match match = pathMatcher.match(path);
            if (match == null) {
                System.out.printf("No root for path %s %n", path);
                return;
            }
            String remaining = path.substring(match.root.length(), path.length() - len);
            if (remaining.startsWith("/")) {
                remaining = remaining.substring(1);
            }
            if ((mdir = TestFileSystem.this.manager.get(dirName = match.dir + remaining)) == null) {
                if (show) {
                    System.out.printf("Dir %s from path %s doesnt exist%n", dirName, log.path);
                } else if (show) {
                    System.out.printf("Dir %s from path %s ok%n", dirName, log.path);
                }
            }
        }
    }

    class MyFF
    implements FileFilter {
        MyFF() {
        }

        public boolean accept(File f) {
            String name = f.getName();
            return name.startsWith("access") && name.endsWith(".log");
        }
    }

    class MyLogFilter
    implements LogReader.LogFilter {
        MyLogFilter() {
        }

        public boolean pass(LogReader.Log log) {
            return log.returnCode == 200 && log.path.startsWith(prefix);
        }
    }
}

