/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dataset.conv.COARDSConvention;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.vertical.AtmosSigma;
import ucar.unidata.geoloc.vertical.HybridSigmaPressure;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.util.Parameter;

public class CSMConvention
extends COARDSConvention {
    protected HashMap ctHash = new HashMap();

    public CSMConvention() {
        this.conventionName = "NCAR-CSM";
    }

    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) {
        List<Variable> vars = ds.getVariables();
        for (Variable var : vars) {
            String unit = var.getUnitsString();
            if (unit == null || !unit.equalsIgnoreCase("hybrid_sigma_pressure") && !unit.equalsIgnoreCase("sigma_level")) continue;
            var.addAttribute(new Attribute("_CoordinateAxisType", AxisType.GeoZ.toString()));
            var.addAttribute(new Attribute("_CoordinateTransformType", TransformType.Vertical.toString()));
            var.addAttribute(new Attribute("_CoordinateAxes", var.getName()));
        }
    }

    protected void findCoordinateAxes(NetcdfDataset ds) {
        for (CoordSysBuilder.VarProcess vp : this.varList) {
            String coordsString;
            if (vp.coordAxes != null || (coordsString = ds.findAttValueIgnoreCase(vp.v, "coordinates", null)) == null) continue;
            vp.coordinates = coordsString;
        }
        super.findCoordinateAxes(ds);
    }

    protected AxisType getAxisType(NetcdfDataset ncd, VariableEnhanced v) {
        AxisType atype = super.getAxisType(ncd, v);
        if (atype != null) {
            return atype;
        }
        String unit = v.getUnitsString();
        if (unit == null) {
            return null;
        }
        if (SimpleUnit.isTimeUnit(unit)) {
            return AxisType.Time;
        }
        return null;
    }

    protected CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
        CoordinateTransform ct = null;
        String unit = ctv.getUnitsString();
        if (unit != null) {
            if (unit.equalsIgnoreCase("hybrid_sigma_pressure")) {
                HybridSigmaPressureBuilder b = new HybridSigmaPressureBuilder();
                ct = b.makeCoordinateTransform(ds, ctv);
            } else if (unit.equalsIgnoreCase("sigma_level")) {
                SigmaBuilder b = new SigmaBuilder();
                ct = b.makeCoordinateTransform(ds, ctv);
            }
        }
        if (ct != null) {
            return ct;
        }
        return super.makeCoordinateTransform(ds, ctv);
    }

    protected boolean addParameter2(CoordinateTransform rs, String paramName, NetcdfFile ds, Variable v, String attName, boolean readData) {
        String varName = ds.findAttValueIgnoreCase(v, attName, null);
        if (null == varName) {
            this.parseInfo.format("CSMConvention No Attribute named %s\n", attName);
            return false;
        }
        Variable dataVar = ds.findVariable(varName = varName.trim());
        if (null == dataVar) {
            this.parseInfo.format("CSMConvention No Variable named %s\n", varName);
            return false;
        }
        if (readData) {
            Array data;
            try {
                data = dataVar.read();
            }
            catch (IOException e) {
                this.parseInfo.format("CSMConvention failed on read of %s err= %s\n", varName, e.getMessage());
                return false;
            }
            double[] vals = (double[])data.get1DJavaArray(Double.TYPE);
            rs.addParameter(new Parameter(paramName, vals));
        } else {
            rs.addParameter(new Parameter(paramName, varName));
        }
        return true;
    }

    private class SigmaBuilder
    extends AbstractCoordTransBuilder {
        private SigmaBuilder() {
        }

        public String getTransformName() {
            return "csm_sigma_level";
        }

        public TransformType getTransformType() {
            return TransformType.Vertical;
        }

        public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
            VerticalCT rs = new VerticalCT("sigma-" + ctv.getName(), CSMConvention.this.conventionName, VerticalCT.Type.Sigma, this);
            rs.addParameter(new Parameter("formula", "pressure(x,y,z) = ptop + sigma(z)*(surfacePressure(x,y)-ptop)"));
            if (!CSMConvention.this.addParameter2(rs, "SurfacePressure_variableName", ds, ctv, "PS_var", false)) {
                return null;
            }
            if (!CSMConvention.this.addParameter2(rs, "Sigma_variableName", ds, ctv, "B_var", false)) {
                return null;
            }
            if (!CSMConvention.this.addParameter2(rs, "PressureTop_variableName", ds, ctv, "P0_var", false)) {
                return null;
            }
            CSMConvention.this.parseInfo.format("CSMConvention made SigmaCT %s\n", ctv.getName());
            return rs;
        }

        public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
            return new AtmosSigma(ds, timeDim, vCT.getParameters());
        }
    }

    private class HybridSigmaPressureBuilder
    extends AbstractCoordTransBuilder {
        private HybridSigmaPressureBuilder() {
        }

        public String getTransformName() {
            return "csm_hybrid_sigma_pressure";
        }

        public TransformType getTransformType() {
            return TransformType.Vertical;
        }

        public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable ctv) {
            VerticalCT rs = new VerticalCT(ctv.getName(), this.getTransformName(), VerticalCT.Type.HybridSigmaPressure, this);
            rs.addParameter(new Parameter("formula", "pressure(x,y,z) = a(z)*p0 + b(z)*surfacePressure(x,y)"));
            if (!CSMConvention.this.addParameter2(rs, "SurfacePressure_variableName", ds, ctv, "PS_var", false)) {
                return null;
            }
            if (!CSMConvention.this.addParameter2(rs, "A_variableName", ds, ctv, "A_var", false)) {
                return null;
            }
            if (!CSMConvention.this.addParameter2(rs, "B_variableName", ds, ctv, "B_var", false)) {
                return null;
            }
            if (!CSMConvention.this.addParameter2(rs, "P0_variableName", ds, ctv, "P0_var", false)) {
                return null;
            }
            CSMConvention.this.parseInfo.format("CSMConvention made SigmaPressureCT %s\n", ctv.getName());
            return rs;
        }

        public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
            return new HybridSigmaPressure(ds, timeDim, vCT.getParameters());
        }
    }
}

