/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonRect;

public class PointIteratorFiltered
implements PointFeatureIterator {
    private PointFeatureIterator pfiter;
    private LatLonRect filter_bb;
    private DateRange filter_date;
    private PointFeature pointFeature;
    private boolean done = false;

    PointIteratorFiltered(PointFeatureIterator pfiter, LatLonRect filter_bb, DateRange filter_date) {
        this.pfiter = pfiter;
        this.filter_bb = filter_bb;
        this.filter_date = filter_date;
    }

    public void setBufferSize(int bytes) {
        this.pfiter.setBufferSize(bytes);
    }

    public void cancel() {
        this.pfiter.cancel();
    }

    public boolean hasNext() throws IOException {
        if (this.done) {
            return false;
        }
        this.pointFeature = this.nextFilteredDataPoint();
        return this.pointFeature != null;
    }

    public PointFeature next() throws IOException {
        return this.done ? null : this.pointFeature;
    }

    private boolean filter(PointFeature pdata) {
        if (this.filter_date != null && !this.filter_date.included(pdata.getObservationTimeAsDate())) {
            return false;
        }
        return this.filter_bb == null || this.filter_bb.contains(pdata.getLocation().getLatitude(), pdata.getLocation().getLongitude());
    }

    private PointFeature nextFilteredDataPoint() throws IOException {
        if (this.pfiter == null) {
            return null;
        }
        if (!this.pfiter.hasNext()) {
            return null;
        }
        PointFeature pdata = this.pfiter.next();
        while (!this.filter(pdata)) {
            if (!this.pfiter.hasNext()) {
                return null;
            }
            pdata = this.pfiter.next();
        }
        return pdata;
    }
}

