/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.NestedPointFeatureCollectionIterator;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.point.OneNestedPointCollectionImpl;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;
import ucar.unidata.geoloc.StationImpl;

public abstract class StationProfileFeatureImpl
extends OneNestedPointCollectionImpl
implements StationProfileFeature {
    protected DateUnit timeUnit;
    protected int timeSeriesNpts;
    protected Station s;
    protected NestedPointFeatureCollectionIterator localIterator;

    public StationProfileFeatureImpl(String name, String desc, String wmoId, double lat, double lon, double alt, DateUnit timeUnit, int npts) {
        super(name, FeatureType.STATION_PROFILE);
        this.s = new StationImpl(name, desc, wmoId, lat, lon, alt);
        this.timeUnit = timeUnit;
        this.timeSeriesNpts = npts;
    }

    public StationProfileFeatureImpl(Station s, DateUnit timeUnit, int npts) {
        super(s.getName(), FeatureType.STATION_PROFILE);
        this.s = s;
        this.timeUnit = timeUnit;
        this.timeSeriesNpts = npts;
    }

    public String getWmoId() {
        return this.s.getWmoId();
    }

    public int size() {
        return this.timeSeriesNpts;
    }

    public String getName() {
        return this.s.getName();
    }

    public String getDescription() {
        return this.s.getDescription();
    }

    public double getLatitude() {
        return this.s.getLatitude();
    }

    public double getLongitude() {
        return this.s.getLongitude();
    }

    public double getAltitude() {
        return this.s.getAltitude();
    }

    public LatLonPoint getLatLon() {
        return this.s.getLatLon();
    }

    public boolean isMissing() {
        return Double.isNaN(this.getLatitude()) || Double.isNaN(this.getLongitude());
    }

    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    public ProfileFeature next() throws IOException {
        return (ProfileFeature)((Object)this.localIterator.next());
    }

    public void resetIteration() throws IOException {
        this.localIterator = this.getNestedPointFeatureCollectionIterator(-1);
    }

    public int compareTo(Station so) {
        return this.s.getName().compareTo(so.getName());
    }

    public StationProfileFeature subset(DateRange dateRange) throws IOException {
        return null;
    }

    public StationProfileFeature subset(LatLonRect dateRange) throws IOException {
        return this;
    }
}

