/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.List;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.NestedPointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.OneNestedPointCollectionImpl;
import ucar.nc2.ft.point.PointCollectionIteratorFiltered;
import ucar.nc2.ft.point.StationHelper;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StationTimeSeriesCollectionImpl
extends OneNestedPointCollectionImpl
implements StationTimeSeriesFeatureCollection {
    protected StationHelper stationHelper;
    protected PointFeatureCollectionIterator localIterator;

    public StationTimeSeriesCollectionImpl(String name) {
        super(name, FeatureType.STATION);
    }

    @Override
    public List<Station> getStations() {
        return this.stationHelper.getStations();
    }

    @Override
    public List<Station> getStations(LatLonRect boundingBox) throws IOException {
        return this.stationHelper.getStations(boundingBox);
    }

    @Override
    public Station getStation(String name) {
        return this.stationHelper.getStation(name);
    }

    @Override
    public LatLonRect getBoundingBox() {
        return this.stationHelper.getBoundingBox();
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(List<Station> stations) throws IOException {
        if (stations == null) {
            return this;
        }
        return new StationFeatureCollectionSubset(this, stations);
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(LatLonRect boundingBox) throws IOException {
        return this.subset(this.getStations(boundingBox));
    }

    @Override
    public StationTimeSeriesFeature getStationFeature(Station s) throws IOException {
        return (StationTimeSeriesFeature)s;
    }

    @Override
    public NestedPointFeatureCollectionIterator getNestedPointFeatureCollectionIterator(int bufferSize) throws IOException {
        throw new UnsupportedOperationException("StationFeatureCollection does not implement getNestedPointFeatureCollection()");
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    @Override
    public StationTimeSeriesFeature next() throws IOException {
        return (StationTimeSeriesFeature)this.localIterator.next();
    }

    @Override
    public void resetIteration() throws IOException {
        this.localIterator = this.getPointFeatureCollectionIterator(-1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StationFeatureCollectionSubset
    extends StationTimeSeriesCollectionImpl {
        StationTimeSeriesCollectionImpl from;

        StationFeatureCollectionSubset(StationTimeSeriesCollectionImpl from, List<Station> stations) {
            super(from.getName());
            this.from = from;
            this.stationHelper = new StationHelper();
            this.stationHelper.setStations(stations);
        }

        @Override
        public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
            return new PointCollectionIteratorFiltered(this.from.getPointFeatureCollectionIterator(bufferSize), new Filter());
        }

        private class Filter
        implements PointFeatureCollectionIterator.Filter {
            private Filter() {
            }

            public boolean filter(PointFeatureCollection pointFeatureCollection) {
                StationTimeSeriesFeature stationFeature = (StationTimeSeriesFeature)pointFeatureCollection;
                return StationFeatureCollectionSubset.this.stationHelper.getStation(stationFeature.getName()) != null;
            }
        }
    }
}

