/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.util.Formatter;
import ucar.nc2.Dimension;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.Evaluator;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;

public class Madis
extends TableConfigurerImpl {
    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        if (wantFeatureType != FeatureType.ANY_POINT && wantFeatureType != FeatureType.STATION && wantFeatureType != FeatureType.POINT) {
            return false;
        }
        if (!ds.hasUnlimitedDimension()) {
            return false;
        }
        if (ds.findDimension("recNum") == null) {
            return false;
        }
        if (ds.findVariable("staticIds") == null) {
            return false;
        }
        if (ds.findVariable("nStaticIds") == null) {
            return false;
        }
        if (ds.findVariable("lastRecord") == null) {
            return false;
        }
        if (ds.findVariable("prevRecord") == null) {
            return false;
        }
        VNames vn = this.getVariableNames(ds, null);
        if (ds.findVariable(vn.lat) == null) {
            return false;
        }
        if (ds.findVariable(vn.lon) == null) {
            return false;
        }
        return ds.findVariable(vn.obsTime) != null;
    }

    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) {
        Dimension obsDim = Evaluator.getDimension(ds, "recNum", errlog);
        if (obsDim == null) {
            errlog.format("MADIS: must have an Observation dimension: named recNum", new Object[0]);
            return null;
        }
        VNames vn = this.getVariableNames(ds, errlog);
        boolean isPsuedo = !obsDim.isUnlimited();
        FeatureType ft = Evaluator.getFeatureType(ds, ":thredds_data_type", errlog);
        if (null == ft) {
            ft = FeatureType.POINT;
        }
        TableConfig ptTable = new TableConfig(Table.Type.Structure, isPsuedo ? obsDim.getName() : "record");
        ptTable.structName = "record";
        ptTable.featureType = FeatureType.POINT;
        ptTable.isPsuedoStructure = isPsuedo;
        ptTable.dim = obsDim;
        ptTable.time = vn.obsTime;
        ptTable.timeNominal = vn.nominalTime;
        ptTable.lat = vn.lat;
        ptTable.lon = vn.lon;
        ptTable.elev = vn.elev;
        return ptTable;
    }

    private VNames getVariableNames(NetcdfDataset ds, Formatter errlog) {
        String[] vals;
        VNames vn = new VNames();
        String val = ds.findAttValueIgnoreCase(null, "stationLocationVariables", null);
        if (val == null) {
            if (errlog != null) {
                errlog.format(" Cant find global attribute stationLocationVariables\n", new Object[0]);
            }
            vn.lat = "latitude";
            vn.lon = "longitude";
        } else {
            vals = val.split(",");
            if (vals.length > 0) {
                vn.lat = vals[0];
            }
            if (vals.length > 1) {
                vn.lon = vals[1];
            }
            if (vals.length > 2) {
                vn.elev = vals[2];
            }
        }
        val = ds.findAttValueIgnoreCase(null, "timeVariables", null);
        if (val == null) {
            if (errlog != null) {
                errlog.format(" Cant find global attribute timeVariables\n", new Object[0]);
            }
            vn.obsTime = "observationTime";
            vn.nominalTime = "reportTime";
        } else {
            vals = val.split(",");
            if (vals.length > 0) {
                vn.obsTime = vals[0];
            }
            if (vals.length > 1) {
                vn.nominalTime = vals[1];
            }
        }
        return vn;
    }

    private class VNames {
        String lat;
        String lon;
        String elev;
        String obsTime;
        String nominalTime;

        private VNames() {
        }
    }
}

