/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.iosp.bufr.BufrDataDescriptionSection;
import ucar.nc2.iosp.bufr.BufrDataSection;
import ucar.nc2.iosp.bufr.BufrIdentificationSection;
import ucar.nc2.iosp.bufr.BufrIndicatorSection;
import ucar.nc2.iosp.bufr.BufrNumbers;
import ucar.nc2.iosp.bufr.Message;
import ucar.unidata.io.KMPMatch;
import ucar.unidata.io.RandomAccessFile;

public class MessageScanner {
    public static final int MAX_MESSAGE_SIZE = 500000;
    private static Logger log = LoggerFactory.getLogger(MessageScanner.class);
    private static final KMPMatch matcher = new KMPMatch("BUFR".getBytes());
    private RandomAccessFile raf = null;
    private int countMsgs = 0;
    private int countObs = 0;
    private byte[] header;
    private long startPos = 0L;
    private long lastPos = 0L;
    private long nbytes = 0L;

    public static boolean isValidFile(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        if (!raf.searchForward(matcher, 8000)) {
            return false;
        }
        raf.skipBytes(4);
        BufrIndicatorSection is = new BufrIndicatorSection(raf);
        if (is.getBufrEdition() > 4) {
            return false;
        }
        return (long)is.getBufrLength() <= raf.length();
    }

    public MessageScanner(RandomAccessFile raf) throws IOException {
        this(raf, 0L);
    }

    public MessageScanner(RandomAccessFile raf, long startPos) throws IOException {
        this.raf = raf;
        raf.seek(startPos);
        raf.order(0);
    }

    public boolean hasNext() throws IOException {
        if (this.lastPos >= this.raf.length()) {
            return false;
        }
        this.raf.seek(this.lastPos);
        boolean more = this.raf.searchForward(matcher, -1);
        if (more) {
            long stop = this.raf.getFilePointer();
            int sizeHeader = (int)(stop - this.lastPos);
            if (sizeHeader > 30) {
                sizeHeader = 30;
            }
            this.header = new byte[sizeHeader];
            this.startPos = stop - (long)sizeHeader;
            this.raf.seek(this.startPos);
            this.raf.read(this.header);
        }
        return more;
    }

    public Message next() throws IOException {
        long start = this.raf.getFilePointer();
        this.raf.seek(start + 4L);
        BufrIndicatorSection is = new BufrIndicatorSection(this.raf);
        BufrIdentificationSection ids = new BufrIdentificationSection(this.raf, is);
        BufrDataDescriptionSection dds = new BufrDataDescriptionSection(this.raf);
        long dataPos = this.raf.getFilePointer();
        int dataLength = BufrNumbers.uint3(this.raf);
        BufrDataSection dataSection = new BufrDataSection(dataPos, dataLength);
        this.lastPos = dataPos + (long)dataLength + 4L;
        this.nbytes += this.lastPos - this.startPos;
        if (is.getBufrEdition() > 4) {
            log.warn("Illegal edition - BUFR message at pos " + start + " header= " + MessageScanner.cleanup(this.header));
            return null;
        }
        if (is.getBufrEdition() < 2) {
            log.warn("Edition " + is.getBufrEdition() + " is not supported - BUFR message at pos " + start + " header= " + MessageScanner.cleanup(this.header));
            return null;
        }
        long ending = dataPos + (long)dataLength;
        this.raf.seek(dataPos + (long)dataLength);
        for (int i = 0; i < 3; ++i) {
            if (this.raf.read() == 55) continue;
            log.warn("Missing End of BUFR message at pos=" + ending + " header= " + MessageScanner.cleanup(this.header));
            return null;
        }
        if (this.raf.read() != 55) {
            this.raf.seek(dataPos + (long)dataLength - 1L);
            if (this.raf.read() != 55) {
                log.warn("Missing End of BUFR message at pos=" + ending + " header= " + MessageScanner.cleanup(this.header) + " edition= " + is.getBufrEdition());
                return null;
            }
            log.warn("End of BUFR message off-by-one at pos= " + ending + " header= " + MessageScanner.cleanup(this.header) + " edition= " + is.getBufrEdition());
            --this.lastPos;
        }
        Message m = new Message(this.raf, is, ids, dds, dataSection);
        m.setHeader(MessageScanner.cleanup(this.header));
        m.setStartPos(start);
        ++this.countMsgs;
        this.countObs += dds.getNumberDatasets();
        this.raf.seek(start + (long)is.getBufrLength());
        return m;
    }

    public byte[] getMessageBytesFromLast(Message m) throws IOException {
        long startPos = m.getStartPos();
        int length = (int)(this.lastPos - startPos);
        byte[] result = new byte[length];
        this.raf.seek(startPos);
        this.raf.readFully(result);
        return result;
    }

    public byte[] getMessageBytes(Message m) throws IOException {
        long startPos = m.getStartPos();
        int length = m.is.getBufrLength();
        byte[] result = new byte[length];
        this.raf.seek(startPos);
        this.raf.readFully(result);
        return result;
    }

    public int getTotalObs() {
        return this.countObs;
    }

    public int getTotalMessages() {
        return this.countMsgs;
    }

    private static String cleanup(byte[] h) {
        byte[] bb = new byte[h.length];
        int count = 0;
        for (byte b : h) {
            if (b < 32 || b >= 127) continue;
            bb[count++] = b;
        }
        return new String(bb, 0, count);
    }

    public long writeCurrentMessage(WritableByteChannel out) throws IOException {
        long nbytes = this.lastPos - this.startPos;
        return this.raf.readToByteChannel(out, this.startPos, nbytes);
    }
}

