/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.nc2.iosp.bufr.tables.BufrTables;
import ucar.nc2.iosp.bufr.tables.TableB;
import ucar.nc2.iosp.bufr.tables.TableD;

public final class BufrReadMnemonic {
    private static final Pattern fields3 = Pattern.compile("^\\|\\s+(.*)\\s+\\|\\s+(.*)\\s+\\|\\s+(.*)\\s*\\|");
    private static final Pattern fields2 = Pattern.compile("^\\|\\s+(.*)\\s+\\|\\s+(.*)\\s+\\|");
    private static final Pattern fields5 = Pattern.compile("^\\|\\s+(.*)\\s+\\|\\s+(.*)\\s+\\|\\s+(.*)\\s+\\|\\s+(.*)\\s+\\|\\s+(.*)\\s+\\|");
    private static final Pattern ints0123 = Pattern.compile("^(0|1|2|3)");
    private static final Pattern ints6 = Pattern.compile("^\\d{6}");
    private static final int XlocalCutoff = 48;
    private static final int YlocalCutoff = 192;
    private static final boolean debugTable = false;
    private static final String RESOURCE_PATH = "resources/bufr/tables/";
    private TableB tableB;
    private TableD tableD;

    public boolean readMnemonic(String tablename) {
        try {
            String line;
            Matcher m;
            String line2;
            HashMap<String, String> number = new HashMap<String, String>();
            HashMap<String, String> desc = new HashMap<String, String>();
            HashMap<String, String> mnseq = new HashMap<String, String>();
            InputStream ios = this.open(tablename);
            if (ios == null) {
                return false;
            }
            BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));
            while (!(line2 = dataIS.readLine()).contains("MNEMONIC")) {
            }
            while (!(line2 = dataIS.readLine()).contains("MNEMONIC")) {
                if (line2.contains("----") || line2.startsWith("*") || line2.startsWith("|       ") || !(m = fields3.matcher(line2)).find()) continue;
                if (m.group(2).startsWith("3")) {
                    number.put(m.group(1).trim(), m.group(2));
                    desc.put(m.group(1).trim(), m.group(3).replace("TABLE D ENTRY - ", "").trim());
                    continue;
                }
                if (m.group(2).startsWith("0")) {
                    number.put(m.group(1).trim(), m.group(2));
                    desc.put(m.group(1).trim(), m.group(3).replace("TABLE B ENTRY - ", "").trim());
                    continue;
                }
                if (!m.group(2).startsWith("A")) continue;
                number.put(m.group(1).trim(), m.group(2));
                desc.put(m.group(1).trim(), m.group(3).replace("TABLE A ENTRY - ", "").trim());
            }
            while (!(line2 = dataIS.readLine()).contains("MNEMONIC")) {
                if (line2.contains("----") || line2.startsWith("|       ") || line2.startsWith("*") || !(m = fields2.matcher(line2)).find()) continue;
                if (mnseq.containsKey(m.group(1).trim())) {
                    String value = (String)mnseq.get(m.group(1).trim());
                    value = value + " " + m.group(2);
                    mnseq.put(m.group(1).trim(), value);
                    continue;
                }
                mnseq.put(m.group(1).trim(), m.group(2));
            }
            this.tableD = new TableD(tablename, tablename);
            for (String key : mnseq.keySet()) {
                String Y;
                String X;
                String F;
                String seq = (String)mnseq.get(key);
                seq = seq.replaceAll("\\<", "1-1-0 0-31-0 ");
                seq = seq.replaceAll("\\>", "");
                seq = seq.replaceAll("\\{", "1-1-0 0-31-1 ");
                seq = seq.replaceAll("\\}", "");
                seq = seq.replaceAll("\\(", "1-1-0 0-31-2 ");
                seq = seq.replaceAll("\\)", "");
                StringTokenizer stoke = new StringTokenizer(seq, " ");
                ArrayList<Short> list = new ArrayList<Short>();
                while (stoke.hasMoreTokens()) {
                    String mn = stoke.nextToken();
                    if (mn.charAt(1) == '-') {
                        list.add(Descriptor.getFxy(mn));
                        continue;
                    }
                    m = ints6.matcher(mn);
                    if (m.find()) {
                        F = mn.substring(0, 1);
                        X = this.removeLeading0(mn.substring(1, 3));
                        Y = this.removeLeading0(mn.substring(3));
                        list.add(Descriptor.getFxy(F + "-" + X + "-" + Y));
                        continue;
                    }
                    if (mn.startsWith("\"")) {
                        int idx = mn.lastIndexOf(34);
                        String count = mn.substring(idx + 1);
                        list.add(Descriptor.getFxy("1-1-" + count));
                        mn = mn.substring(1, idx);
                    }
                    if (mn.startsWith(".")) {
                        String des = mn.substring(mn.length() - 4);
                        mn = mn.replace(des, "....");
                    }
                    String fxy = (String)number.get(mn);
                    String F2 = fxy.substring(0, 1);
                    String X2 = this.removeLeading0(fxy.substring(1, 3));
                    String Y2 = this.removeLeading0(fxy.substring(3));
                    list.add(Descriptor.getFxy(F2 + "-" + X2 + "-" + Y2));
                }
                String fxy = (String)number.get(key);
                F = fxy.substring(0, 1);
                if (F.equals("A")) {
                    F = "3";
                }
                X = this.removeLeading0(fxy.substring(1, 3));
                Y = this.removeLeading0(fxy.substring(3));
                if (48 > Integer.parseInt(X) && 192 > Integer.parseInt(Y)) continue;
                short seqX = Short.parseShort(X.trim());
                short seqY = Short.parseShort(Y.trim());
                this.tableD.addDescriptor(seqX, seqY, key, list);
            }
            ArrayList<Short> list = new ArrayList<Short>();
            list.add(Descriptor.getFxy("1-1-0"));
            list.add(Descriptor.getFxy("0-31-2"));
            this.tableD.addDescriptor((short)60, (short)1, "", list);
            list = new ArrayList();
            list.add(Descriptor.getFxy("1-1-0"));
            list.add(Descriptor.getFxy("0-31-1"));
            this.tableD.addDescriptor((short)60, (short)2, "", list);
            list = new ArrayList();
            list.add(Descriptor.getFxy("1-1-0"));
            list.add(Descriptor.getFxy("0-31-1"));
            this.tableD.addDescriptor((short)60, (short)3, "", list);
            list = new ArrayList();
            list.add(Descriptor.getFxy("1-1-0"));
            list.add(Descriptor.getFxy("0-31-0"));
            this.tableD.addDescriptor((short)60, (short)4, "", list);
            this.tableB = new TableB(tablename, tablename);
            while ((line = dataIS.readLine()) != null && !line.contains("MNEMONIC")) {
                if (line.startsWith("|       ") || line.startsWith("*") || !(m = fields5.matcher(line)).find() || m.group(1).equals("") || !number.containsKey(m.group(1).trim())) continue;
                String fxy = (String)number.get(m.group(1).trim());
                String F = fxy.substring(0, 1);
                String X = fxy.substring(1, 3);
                String Y = fxy.substring(3);
                String name = (String)desc.get(m.group(1).trim());
                if (48 > Integer.parseInt(X) && 192 > Integer.parseInt(Y)) continue;
                short x = Short.parseShort(X.trim());
                short y = Short.parseShort(Y.trim());
                int scale = Integer.parseInt(m.group(2).trim());
                int refVal = Integer.parseInt(m.group(3).trim());
                int width = Integer.parseInt(m.group(4).trim());
                this.tableB.addDescriptor(x, y, scale, refVal, width, name, m.group(5).trim());
            }
            this.tableB.addDescriptor((short)63, (short)0, 0, 0, 16, "Byte count", "Numeric");
            BufrTables.addTableB(tablename, this.tableB);
            BufrTables.addTableD(tablename, this.tableD);
            dataIS.close();
        }
        catch (Exception ioe) {
            return false;
        }
        return true;
    }

    private InputStream open(String location) throws IOException {
        String tmp;
        InputStream ios = null;
        ClassLoader cl = BufrReadMnemonic.class.getClassLoader();
        ios = cl.getResourceAsStream(tmp = RESOURCE_PATH + location);
        if (ios != null) {
            return ios;
        }
        if (location.startsWith("http:")) {
            URL url = new URL(location);
            ios = url.openStream();
        } else {
            ios = new FileInputStream(location);
        }
        return ios;
    }

    private String removeLeading0(String number) {
        if (number.length() == 2 && number.startsWith("0")) {
            number = number.substring(1);
        } else if (number.length() == 3 && number.startsWith("00")) {
            number = number.substring(2);
        } else if (number.length() == 3 && number.startsWith("0")) {
            number = number.substring(1);
        }
        return number;
    }

    public final TableB getTableB() {
        return this.tableB;
    }

    public final TableD getTableD() {
        return this.tableD;
    }

    public static void main(String[] args) throws IOException {
        BufrReadMnemonic brm = new BufrReadMnemonic();
        brm.readMnemonic("bufrtab.ETACLS1");
        TableB tableB = brm.getTableB();
        TableD tableD = brm.getTableD();
        Formatter out = new Formatter(System.out);
        tableB.show(out);
        tableD.show(out);
    }
}

