/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.mcidas;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.FileWriter;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.mcidas.AreaReader;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class AreaServiceProvider
extends AbstractIOServiceProvider {
    protected AreaReader areaReader;

    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        return AreaReader.isValidFile(raf);
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        long start = System.currentTimeMillis();
        if (this.areaReader == null) {
            this.areaReader = new AreaReader();
        }
        try {
            this.areaReader.init(raf, ncfile);
        }
        catch (Exception e) {
            // empty catch block
        }
        long end = System.currentTimeMillis() - start;
    }

    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        long start = System.currentTimeMillis();
        Array array = this.areaReader.readVariable(v2, section);
        long end = System.currentTimeMillis() - start;
        return array;
    }

    public boolean syncExtend() throws IOException {
        return false;
    }

    public boolean sync() {
        return true;
    }

    public void close() throws IOException {
        if (this.areaReader != null) {
            this.areaReader = null;
        }
    }

    public static void main(String[] args) throws IOException {
        AreaServiceProvider areaiosp = new AreaServiceProvider();
        RandomAccessFile rf = new RandomAccessFile(args[0], "r", 2048);
        MakeNetcdfFile ncfile = new MakeNetcdfFile(areaiosp, rf, args[0], null);
        if (args.length > 1) {
            FileWriter.writeToFile(ncfile, args[1]);
        }
    }

    protected static class MakeNetcdfFile
    extends NetcdfFile {
        MakeNetcdfFile(IOServiceProvider spi, RandomAccessFile raf, String location, CancelTask cancelTask) throws IOException {
            super(spi, raf, location, cancelTask);
        }
    }
}

