/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.uf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.uf.Ray;
import ucar.nc2.iosp.uf.UFheader;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.io.RandomAccessFile;

public class UFiosp
extends AbstractIOServiceProvider {
    private static final int MISSING_INT = -9999;
    private static final float MISSING_FLOAT = Float.NaN;
    private NetcdfFile ncfile;
    private RandomAccessFile myRaf;
    protected UFheader headerParser;
    private DateFormatter formatter = new DateFormatter();
    private double radarRadius = 100000.0;

    public boolean isValidFile(RandomAccessFile raf) {
        UFheader localHeader = new UFheader();
        return localHeader.isValidFile(raf);
    }

    public void open(RandomAccessFile raf, NetcdfFile file, CancelTask cancelTask) throws IOException {
        this.ncfile = file;
        this.myRaf = raf;
        this.headerParser = new UFheader();
        this.headerParser.read(this.myRaf, this.ncfile);
        HashMap variables = this.headerParser.variableGroup;
        Set vSet = variables.keySet();
        for (String key : vSet) {
            ArrayList group = (ArrayList)variables.get(key);
            List firstGroup = (List)group.get(0);
            Ray ray0 = (Ray)firstGroup.get(0);
            this.makeVariable(this.ncfile, ray0.getDatatypeName(key), ray0.getDatatypeName(key), key, group);
        }
        this.ncfile.addAttribute(null, new Attribute("Conventions", "_Coordinates"));
        this.ncfile.addAttribute(null, new Attribute("format", this.headerParser.getDataFormat()));
        this.ncfile.addAttribute(null, new Attribute("cdm_data_type", FeatureType.RADIAL.toString()));
        this.ncfile.addAttribute(null, new Attribute("StationLatitude", new Double(this.headerParser.getStationLatitude())));
        this.ncfile.addAttribute(null, new Attribute("StationLongitude", new Double(this.headerParser.getStationLongitude())));
        this.ncfile.addAttribute(null, new Attribute("StationElevationInMeters", new Double(this.headerParser.getStationElevation())));
        this.ncfile.addAttribute(null, new Attribute("time_coverage_start", this.formatter.toDateTimeStringISO(this.headerParser.getStartDate())));
        this.ncfile.addAttribute(null, new Attribute("time_coverage_end", this.formatter.toDateTimeStringISO(this.headerParser.getEndDate())));
        double latRadiusDegrees = Math.toDegrees(this.radarRadius / Earth.getRadius());
        this.ncfile.addAttribute(null, new Attribute("geospatial_lat_min", new Double((double)this.headerParser.getStationLatitude() - latRadiusDegrees)));
        this.ncfile.addAttribute(null, new Attribute("geospatial_lat_max", new Double((double)this.headerParser.getStationLatitude() + latRadiusDegrees)));
        double cosLat = Math.cos(Math.toRadians(this.headerParser.getStationLatitude()));
        double lonRadiusDegrees = Math.toDegrees(this.radarRadius / cosLat / Earth.getRadius());
        this.ncfile.addAttribute(null, new Attribute("geospatial_lon_min", new Double((double)this.headerParser.getStationLongitude() - lonRadiusDegrees)));
        this.ncfile.addAttribute(null, new Attribute("geospatial_lon_max", new Double((double)this.headerParser.getStationLongitude() + lonRadiusDegrees)));
        this.ncfile.addAttribute(null, new Attribute("history", "direct read of Nexrad Level 2 file into NetCDF-Java 2.2 API"));
        this.ncfile.addAttribute(null, new Attribute("DataType", "Radial"));
        this.ncfile.addAttribute(null, new Attribute("Title", "Nexrad Level 2 Station " + this.headerParser.getStationId() + " from " + this.formatter.toDateTimeStringISO(this.headerParser.getStartDate()) + " to " + this.formatter.toDateTimeStringISO(this.headerParser.getEndDate())));
        this.ncfile.addAttribute(null, new Attribute("Summary", "Weather Surveillance Radar-1988 Doppler (WSR-88D) Level II data are the three meteorological base data quantities: reflectivity, mean radial velocity, and spectrum width."));
        this.ncfile.addAttribute(null, new Attribute("keywords", "WSR-88D; NEXRAD; Radar Level II; reflectivity; mean radial velocity; spectrum width"));
        this.ncfile.addAttribute(null, new Attribute("SweepMode", new Short(this.headerParser.getSweepMode())));
        this.ncfile.finish();
    }

    public Variable makeVariable(NetcdfFile ncfile, String shortName, String longName, String abbrev, List groups) throws IOException {
        int nscans = groups.size();
        if (nscans == 0) {
            throw new IllegalStateException("No data for " + shortName);
        }
        List firstGroup = (List)groups.get(0);
        Ray firstRay = (Ray)firstGroup.get(0);
        int ngates = firstRay.getGateCount(abbrev);
        String scanDimName = "scan" + abbrev;
        String gateDimName = "gate" + abbrev;
        String radialDimName = "radial" + abbrev;
        Dimension scanDim = new Dimension(scanDimName, nscans);
        Dimension gateDim = new Dimension(gateDimName, ngates);
        Dimension radialDim = new Dimension(radialDimName, this.headerParser.getMaxRadials(), true);
        ncfile.addDimension(null, scanDim);
        ncfile.addDimension(null, gateDim);
        ncfile.addDimension(null, radialDim);
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        dims.add(scanDim);
        dims.add(radialDim);
        dims.add(gateDim);
        Variable v = new Variable(ncfile, null, null, shortName + abbrev);
        v.setDataType(DataType.SHORT);
        v.setDimensions(dims);
        ncfile.addVariable(null, v);
        v.addAttribute(new Attribute("units", firstRay.getDatatypeUnits(abbrev)));
        v.addAttribute(new Attribute("long_name", longName));
        v.addAttribute(new Attribute("abbrev", abbrev));
        v.addAttribute(new Attribute("missing_value", firstRay.getMissingData()));
        v.addAttribute(new Attribute("signal_below_threshold", firstRay.getDatatypeRangeFoldingThreshhold(abbrev)));
        v.addAttribute(new Attribute("scale_factor", Float.valueOf(firstRay.getDatatypeScaleFactor(abbrev))));
        v.addAttribute(new Attribute("add_offset", Float.valueOf(firstRay.getDatatypeAddOffset(abbrev))));
        v.addAttribute(new Attribute("range_folding_threshold", firstRay.getDatatypeRangeFoldingThreshhold(abbrev)));
        ArrayList<Dimension> dim2 = new ArrayList<Dimension>();
        dim2.add(scanDim);
        dim2.add(radialDim);
        String timeCoordName = "time" + abbrev;
        Variable timeVar = new Variable(ncfile, null, null, timeCoordName);
        timeVar.setDataType(DataType.INT);
        timeVar.setDimensions(dim2);
        ncfile.addVariable(null, timeVar);
        Date d = firstRay.getDate();
        String units = "msecs since " + this.formatter.toDateTimeStringISO(d);
        timeVar.addAttribute(new Attribute("long_name", "time since base date"));
        timeVar.addAttribute(new Attribute("units", units));
        timeVar.addAttribute(new Attribute("missing_value", firstRay.getMissingData()));
        timeVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        String elevCoordName = "elevation" + abbrev;
        Variable elevVar = new Variable(ncfile, null, null, elevCoordName);
        elevVar.setDataType(DataType.FLOAT);
        elevVar.setDimensions(dim2);
        ncfile.addVariable(null, elevVar);
        elevVar.addAttribute(new Attribute("units", "degrees"));
        elevVar.addAttribute(new Attribute("long_name", "elevation angle in degres: 0 = parallel to pedestal base, 90 = perpendicular"));
        elevVar.addAttribute(new Attribute("missing_value", firstRay.getMissingData()));
        elevVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.RadialElevation.toString()));
        String aziCoordName = "azimuth" + abbrev;
        Variable aziVar = new Variable(ncfile, null, null, aziCoordName);
        aziVar.setDataType(DataType.FLOAT);
        aziVar.setDimensions(dim2);
        ncfile.addVariable(null, aziVar);
        aziVar.addAttribute(new Attribute("units", "degrees"));
        aziVar.addAttribute(new Attribute("long_name", "azimuth angle in degrees: 0 = true north, 90 = east"));
        aziVar.addAttribute(new Attribute("missing_value", firstRay.getMissingData()));
        aziVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.RadialAzimuth.toString()));
        String gateCoordName = "distance" + abbrev;
        Variable gateVar = new Variable(ncfile, null, null, gateCoordName);
        gateVar.setDataType(DataType.FLOAT);
        gateVar.setDimensions(gateDimName);
        Array data = Array.makeArray(DataType.FLOAT, ngates, firstRay.getGateStart(abbrev), firstRay.getGateSize(abbrev));
        gateVar.setCachedData(data, false);
        ncfile.addVariable(null, gateVar);
        gateVar.addAttribute(new Attribute("units", "m"));
        gateVar.addAttribute(new Attribute("long_name", "radial distance to start of gate"));
        gateVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.RadialDistance.toString()));
        String nradialsName = "numRadials" + abbrev;
        Variable nradialsVar = new Variable(ncfile, null, null, nradialsName);
        nradialsVar.setDataType(DataType.INT);
        nradialsVar.setDimensions(scanDim.getName());
        nradialsVar.addAttribute(new Attribute("long_name", "number of valid radials in this scan"));
        ncfile.addVariable(null, nradialsVar);
        String ngateName = "numGates" + abbrev;
        Variable ngateVar = new Variable(ncfile, null, null, ngateName);
        ngateVar.setDataType(DataType.INT);
        ngateVar.setDimensions(scanDim.getName());
        ngateVar.addAttribute(new Attribute("long_name", "number of valid gates in this scan"));
        ncfile.addVariable(null, ngateVar);
        this.makeCoordinateDataWithMissing(abbrev, timeVar, elevVar, aziVar, nradialsVar, ngateVar, groups);
        String coordinates = timeCoordName + " " + elevCoordName + " " + aziCoordName + " " + gateCoordName;
        v.addAttribute(new Attribute("_CoordinateAxes", coordinates));
        int nradials = radialDim.getLength();
        Ray[][] map = new Ray[nscans][nradials];
        for (int i = 0; i < groups.size(); ++i) {
            Ray[] mapScan = map[i];
            List group = (List)groups.get(i);
            int radial = 0;
            Iterator i$ = group.iterator();
            while (i$.hasNext()) {
                Ray r;
                mapScan[radial] = r = (Ray)i$.next();
                ++radial;
            }
        }
        Vgroup vg = new Vgroup(abbrev, map);
        v.setSPobject(vg);
        return v;
    }

    private void makeCoordinateDataWithMissing(String abbrev, Variable time, Variable elev, Variable azi, Variable nradialsVar, Variable ngatesVar, List groups) {
        Array timeData = Array.factory(time.getDataType().getPrimitiveClassType(), time.getShape());
        Index timeIndex = timeData.getIndex();
        Array elevData = Array.factory(elev.getDataType().getPrimitiveClassType(), elev.getShape());
        Index elevIndex = elevData.getIndex();
        Array aziData = Array.factory(azi.getDataType().getPrimitiveClassType(), azi.getShape());
        Index aziIndex = aziData.getIndex();
        Array nradialsData = Array.factory(nradialsVar.getDataType().getPrimitiveClassType(), nradialsVar.getShape());
        IndexIterator nradialsIter = nradialsData.getIndexIterator();
        Array ngatesData = Array.factory(ngatesVar.getDataType().getPrimitiveClassType(), ngatesVar.getShape());
        IndexIterator ngatesIter = ngatesData.getIndexIterator();
        IndexIterator ii = timeData.getIndexIterator();
        while (ii.hasNext()) {
            ii.setIntNext(-9999);
        }
        ii = elevData.getIndexIterator();
        while (ii.hasNext()) {
            ii.setFloatNext(Float.NaN);
        }
        ii = aziData.getIndexIterator();
        while (ii.hasNext()) {
            ii.setFloatNext(Float.NaN);
        }
        long last_msecs = Integer.MIN_VALUE;
        int nscans = groups.size();
        try {
            for (int scan = 0; scan < nscans; ++scan) {
                List scanGroup = (List)groups.get(scan);
                int nradials = scanGroup.size();
                Ray first = null;
                int radial = 0;
                for (int j = 0; j < nradials; ++j) {
                    Ray r = (Ray)scanGroup.get(j);
                    if (first == null) {
                        first = r;
                    }
                    timeData.setLong(timeIndex.set(scan, radial), r.data_msecs);
                    elevData.setFloat(elevIndex.set(scan, radial), r.getElevation());
                    aziData.setFloat(aziIndex.set(scan, radial), r.getAzimuth());
                    ++radial;
                    last_msecs = r.data_msecs;
                }
                nradialsIter.setIntNext(nradials);
                ngatesIter.setIntNext(first.getGateCount(abbrev));
            }
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            // empty catch block
        }
        time.setCachedData(timeData, false);
        elev.setCachedData(elevData, false);
        azi.setCachedData(aziData, false);
        nradialsVar.setCachedData(nradialsData, false);
        ngatesVar.setCachedData(ngatesData, false);
    }

    public void flush() throws IOException {
        this.myRaf.flush();
    }

    public void close() throws IOException {
        this.myRaf.close();
    }

    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        Vgroup vgroup = (Vgroup)v2.getSPobject();
        Range scanRange = section.getRange(0);
        Range radialRange = section.getRange(1);
        Range gateRange = section.getRange(2);
        Array data = Array.factory(v2.getDataType().getPrimitiveClassType(), section.getShape());
        IndexIterator ii = data.getIndexIterator();
        for (int i = scanRange.first(); i <= scanRange.last(); i += scanRange.stride()) {
            Ray[] mapScan = vgroup.map[i];
            this.readOneScan(mapScan, radialRange, gateRange, vgroup.abbrev, ii);
        }
        return data;
    }

    private void readOneScan(Ray[] mapScan, Range radialRange, Range gateRange, String abbrev, IndexIterator ii) throws IOException {
        for (int i = radialRange.first(); i <= radialRange.last(); i += radialRange.stride()) {
            Ray r = mapScan[i];
            this.readOneRadial(r, abbrev, gateRange, ii);
        }
    }

    private void readOneRadial(Ray r, String abbrev, Range gateRange, IndexIterator ii) throws IOException {
        if (r == null) {
            for (int i = gateRange.first(); i <= gateRange.last(); i += gateRange.stride()) {
                ii.setShortNext(this.headerParser.getMissingData());
            }
            return;
        }
        r.readData(this.myRaf, abbrev, gateRange, ii);
    }

    public static void main(String[] args) throws Exception, IOException, InstantiationException, IllegalAccessException {
        String fileIn = "/home/yuanho/Desktop/ufData/KTLX__sur_20080624.214247.uf";
        NetcdfFile ncf = NetcdfFile.open(fileIn);
        ncf.close();
    }

    private class Vgroup {
        Ray[][] map;
        String abbrev;

        Vgroup(String abbrev, Ray[][] map) {
            this.abbrev = abbrev;
            this.map = map;
        }
    }
}

