/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.WritableByteChannel;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamProto;

public class NcStreamWriter {
    private NetcdfFile ncfile;
    private NcStreamProto.Header header;
    private boolean show = false;
    private int sizeToCache = 100;

    public NcStreamWriter(NetcdfFile ncfile, String location) throws IOException {
        this.ncfile = ncfile;
        NcStreamProto.Group.Builder rootBuilder = NcStream.encodeGroup(ncfile.getRootGroup(), this.sizeToCache);
        NcStreamProto.Header.Builder headerBuilder = NcStreamProto.Header.newBuilder();
        headerBuilder.setName(location == null ? ncfile.getLocation() : location);
        headerBuilder.setRoot(rootBuilder);
        headerBuilder.setIndexPos(0L);
        this.header = headerBuilder.build();
    }

    public void sendHeader(OutputStream out) throws IOException {
        long size = 0L;
        size += (long)this.writeBytes(out, NcStream.MAGIC_START);
        size += (long)this.writeBytes(out, NcStream.MAGIC_HEADER);
        byte[] b = this.header.toByteArray();
        size += (long)this.writeVInt(out, b.length);
        if (this.show) {
            System.out.println("Write Header len=" + b.length);
        }
        System.out.println(" header size=" + (size += (long)this.writeBytes(out, b)));
    }

    public long sendData(OutputStream out, Variable v, Section section, WritableByteChannel wbc) throws IOException {
        long size = 0L;
        size += (long)this.writeBytes(out, NcStream.MAGIC_DATA);
        NcStreamProto.Data dataProto = NcStream.encodeDataProto(v, section);
        byte[] datab = dataProto.toByteArray();
        size += (long)this.writeVInt(out, datab.length);
        size += (long)this.writeBytes(out, datab);
        if (this.show) {
            System.out.println(v.getName() + " proto len=" + datab.length);
        }
        long len = section.computeSize() * (long)v.getElementSize();
        size += (long)this.writeVInt(out, (int)len);
        if (this.show) {
            System.out.println(v.getName() + " data len=" + len);
        }
        out.flush();
        long readCount = 0L;
        try {
            readCount = v.readToByteChannel(section, wbc);
        }
        catch (InvalidRangeException e) {
            // empty catch block
        }
        assert (readCount == len);
        return size;
    }

    public void streamAll(OutputStream out, WritableByteChannel wbc) throws IOException {
        this.sendHeader(out);
        long size = 0L;
        for (Variable v : this.ncfile.getVariables()) {
            size += this.sendData(out, v, v.getShapeAsSection(), wbc);
        }
        System.out.println(" total size=" + size);
    }

    private int writeByte(OutputStream out, byte b) throws IOException {
        out.write(b);
        return 1;
    }

    private int writeBytes(OutputStream out, byte[] b, int offset, int length) throws IOException {
        out.write(b, offset, length);
        return length;
    }

    private int writeBytes(OutputStream out, byte[] b) throws IOException {
        return this.writeBytes(out, b, 0, b.length);
    }

    private int writeVInt(OutputStream out, int i) throws IOException {
        int count = 0;
        while ((i & 0xFFFFFF80) != 0) {
            this.writeByte(out, (byte)(i & 0x7F | 0x80));
            i >>>= 7;
            ++count;
        }
        this.writeByte(out, (byte)i);
        return count + 1;
    }

    private int writeVLong(OutputStream out, long i) throws IOException {
        int count = 0;
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte(out, (byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
            ++count;
        }
        this.writeByte(out, (byte)i);
        return count + 1;
    }
}

