/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream.old;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.stream.old.StreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stream2Netcdf {
    private NetcdfFileWriteable ncfile;
    private Structure record;
    private DataInputStream in;
    private boolean debug = true;

    public Stream2Netcdf(NetcdfFileWriteable ncfile, DataInputStream in) throws IOException, InvalidRangeException {
        this.ncfile = ncfile;
        this.in = in;
        byte[] magicb = new byte[8];
        this.readBytes(magicb);
        String magicS = new String(magicb);
        if (!magicS.equals(StreamWriter.MAGIC_HEADER)) {
            throw new IllegalArgumentException("Not a NetCDF Stream file");
        }
        String magic = this.readHeader();
        try {
            while (true) {
                if (magic.equals(StreamWriter.HEADER)) {
                    magic = this.readHeader();
                }
                if (!magic.equals(StreamWriter.DATA)) break;
                if (ncfile.isDefineMode()) {
                    ncfile.create();
                    if (this.record != null) {
                        ncfile.sendIospMessage("AddRecordStructure");
                        this.record = (Structure)ncfile.findVariable("record");
                    }
                }
                this.readData();
                magic = this.readMagic();
            }
            throw new IllegalStateException("BAD MAGIC " + magic);
        }
        catch (EOFException eof) {
            return;
        }
    }

    String readMagic() throws IOException {
        byte[] magic = new byte[4];
        this.readBytes(magic);
        String magicS = new String(magic);
        if (magicS.equals(StreamWriter.MAGIC)) {
            return this.readMagic();
        }
        return magicS;
    }

    private String readHeader() throws IOException {
        String magic;
        Group root = this.ncfile.getRootGroup();
        while (true) {
            if ((magic = this.readMagic()).equals(StreamWriter.HEADER)) {
                magic = this.readMagic();
            }
            if (magic.equals("Atts")) {
                this.readAtts(root.getAttributes());
                continue;
            }
            if (magic.equals("Dims")) {
                this.readDims(root.getDimensions());
                continue;
            }
            if (!magic.equals("Vars")) break;
            this.readVars(root.getVariables());
        }
        return magic;
    }

    private void readAtts(List<Attribute> atts) throws IOException {
        int natts = this.readVInt();
        if (natts == 0) {
            return;
        }
        for (int i = 0; i < natts; ++i) {
            String name = this.readString();
            int type = this.readVInt();
            int nvals = this.readVInt();
            DataType dt = StreamWriter.getDataType(type);
            Array data = Array.factory(dt, new int[]{nvals});
            this.readValues(data.getIndexIterator(), dt);
            atts.add(new Attribute(name, data));
        }
    }

    private void readValues(IndexIterator ii, DataType dt) throws IOException {
        if (dt == DataType.BYTE) {
            while (ii.hasNext()) {
                ii.setByteNext(this.in.readByte());
            }
        } else if (dt == DataType.CHAR) {
            while (ii.hasNext()) {
                ii.setCharNext((char)this.in.readByte());
            }
        } else if (dt == DataType.SHORT) {
            while (ii.hasNext()) {
                ii.setShortNext(this.in.readShort());
            }
        } else if (dt == DataType.INT) {
            while (ii.hasNext()) {
                ii.setIntNext(this.in.readInt());
            }
        } else if (dt == DataType.FLOAT) {
            while (ii.hasNext()) {
                ii.setFloatNext(this.in.readFloat());
            }
        } else if (dt == DataType.DOUBLE) {
            while (ii.hasNext()) {
                ii.setDoubleNext(this.in.readDouble());
            }
        } else if (dt == DataType.STRING) {
            while (ii.hasNext()) {
                ii.setObjectNext(this.readString());
            }
        } else {
            throw new IllegalStateException("unknown data type == " + (Object)((Object)dt));
        }
    }

    void readDims(List<Dimension> dims) throws IOException {
        int ndims = this.readVInt();
        for (int i = 0; i < ndims; ++i) {
            String name = this.readString();
            int length = this.readVInt();
            byte flags = this.readByte();
            boolean isShared = (flags & 1) != 0;
            boolean isUnlimited = (flags & 2) != 0;
            boolean isVariableLength = (flags & 4) != 0;
            dims.add(new Dimension(name, length, isShared, isUnlimited, isVariableLength));
        }
    }

    void readVars(List<Variable> vars) throws IOException {
        int nvars = this.readVInt();
        for (int i = 0; i < nvars; ++i) {
            String name = this.readString();
            int type = this.readVInt();
            DataType dt = StreamWriter.getDataType(type);
            if (this.debug) {
                System.out.println("  var= " + name + " type = " + type + " dataType = " + (Object)((Object)dt));
            }
            ArrayList<Dimension> dims = new ArrayList<Dimension>();
            this.readDims(dims);
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            this.readAtts(atts);
            if (dt == DataType.STRUCTURE) {
                this.record = new Structure(this.ncfile, null, null, name);
                this.record.setDimensions(dims);
                this.record.getAttributes().addAll(atts);
                continue;
            }
            if (name.startsWith("record.")) {
                String shortName = name.substring(7);
                Variable mv = new Variable(this.ncfile, null, this.record, shortName);
                mv.setDataType(dt);
                mv.setDimensions(dims);
                mv.getAttributes().addAll(atts);
                this.record.addMemberVariable(mv);
                Dimension udim = this.record.getDimension(0);
                assert (udim != null);
                assert (udim.isUnlimited());
                Variable v = new Variable(this.ncfile, null, null, shortName);
                v.setDataType(dt);
                dims.add(0, udim);
                v.setDimensions(dims);
                v.getAttributes().addAll(atts);
                vars.add(v);
                continue;
            }
            Variable v = new Variable(this.ncfile, null, null, name);
            v.setDataType(dt);
            v.setDimensions(dims);
            v.getAttributes().addAll(atts);
            vars.add(v);
        }
    }

    public void readData() throws IOException, InvalidRangeException {
        Structure v;
        String name = this.readString();
        int elemSize = this.readVInt();
        Section s = this.readSection();
        Variable variable = v = name.equals("record") ? this.record : this.ncfile.findVariable(name);
        assert (v != null) : "cant find " + name;
        DataType dt = v.getDataType();
        if (this.debug) {
            System.out.println("  var= " + name + " datatype = " + (Object)((Object)dt) + " elemSize= " + elemSize + " section = " + s);
        }
        if (dt == DataType.STRUCTURE) {
            ArrayStructure data = this.readStructureData(v, s);
            this.ncfile.write(name, s.getOrigin(), data);
        } else {
            Array data = Array.factory(dt, s.getShape());
            this.readValues(data.getIndexIterator(), v.getDataType());
            this.ncfile.write(name, s.getOrigin(), data);
        }
    }

    private ArrayStructure readStructureData(Structure v, Section s) throws IOException {
        StructureMembers sm = v.makeStructureMembers();
        int offset = 0;
        for (StructureMembers.Member m : sm.getMembers()) {
            m.setDataParam(offset);
            offset += m.getSizeBytes();
        }
        sm.setStructureSize(offset);
        int size = (int)((long)sm.getStructureSize() * s.computeSize());
        byte[] ba = new byte[size];
        this.readBytes(ba);
        ByteBuffer bb = ByteBuffer.wrap(ba);
        return new ArrayStructureBB(sm, s.getShape(), bb, 0);
    }

    public Section readSection() throws IOException, InvalidRangeException {
        int rank = this.readVInt();
        Section s = new Section();
        for (int i = 0; i < rank; ++i) {
            int first = this.readVInt();
            int length = this.readVInt();
            s.appendRange(new Range(first, first + length - 1));
        }
        return s;
    }

    private byte readByte() throws IOException {
        return this.in.readByte();
    }

    private void readBytes(byte[] b) throws IOException {
        this.in.readFully(b, 0, b.length);
    }

    private int readVInt() throws IOException {
        byte b = this.readByte();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public String readString() throws IOException {
        int length = this.readVInt();
        char[] chars = new char[length];
        this.readChars(chars, 0, length);
        return new String(chars, 0, length);
    }

    public void readChars(char[] buffer, int start, int length) throws IOException {
        int end = start + length;
        for (int i = start; i < end; ++i) {
            byte b = this.readByte();
            buffer[i] = (b & 0x80) == 0 ? (char)(b & 0x7F) : ((b & 0xE0) != 224 ? (char)((b & 0x1F) << 6 | this.readByte() & 0x3F) : (char)((b & 0xF) << 12 | (this.readByte() & 0x3F) << 6 | this.readByte() & 0x3F));
        }
    }
}

