/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import java.util.Map;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.JoinWalker;
import org.hibernate.util.StringHelper;

public abstract class CollectionJoinWalker
extends JoinWalker {
    public CollectionJoinWalker(SessionFactoryImplementor factory, Map enabledFilters) {
        super(factory, enabledFilters);
    }

    protected StringBuffer whereString(String alias, String[] columnNames, String subselect, int batchSize) {
        if (subselect == null) {
            return super.whereString(alias, columnNames, batchSize);
        }
        StringBuffer buf = new StringBuffer();
        if (columnNames.length > 1) {
            buf.append('(');
        }
        buf.append(StringHelper.join(", ", StringHelper.qualify(alias, columnNames)));
        if (columnNames.length > 1) {
            buf.append(')');
        }
        buf.append(" in ").append('(').append(subselect).append(')');
        return buf;
    }
}

