/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.deployment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import org.alfresco.deployment.FSDeploymentRunnable;
import org.alfresco.deployment.impl.server.Deployment;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.net.www.protocol.http.HttpURLConnection;

public class SurfRefreshRunnable
implements FSDeploymentRunnable {
    private static final long serialVersionUID = -5792264392686730729L;
    private static Log logger = LogFactory.getLog(SurfRefreshRunnable.class);
    private Deployment deployment = null;
    private String surfLocation = null;

    public void init(Deployment deployment) {
        this.deployment = deployment;
    }

    public void setSurfLocation(String surfLocation) {
        this.surfLocation = surfLocation;
    }

    public String getSurfLocation() {
        if (this.surfLocation == null) {
            this.surfLocation = "http://localhost:8080/surf";
        }
        return this.surfLocation;
    }

    public void run() {
        block7: {
            String url = this.getSurfLocation() + "/control/cache/invalidate";
            try {
                if (logger.isDebugEnabled()) {
                    logger.warn((Object)("Refreshing cache with URL: " + url));
                }
                this.fireGet(url);
            }
            catch (MalformedURLException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Unable to refresh Surf cache for URL: " + url), (Throwable)e);
                }
            }
            catch (ProtocolException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Unable to refresh Surf cache for URL: " + url), (Throwable)e);
                }
            }
            catch (IOException e) {
                if (!logger.isWarnEnabled()) break block7;
                logger.warn((Object)("Unable to refresh Surf cache for URL: " + url), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireGet(String urlString) throws MalformedURLException, ProtocolException, IOException {
        URL url = null;
        HttpURLConnection conn = null;
        BufferedReader rd = null;
        StringBuilder sb = null;
        String line = null;
        try {
            url = new URL(urlString);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoOutput(true);
            conn.setReadTimeout(10000);
            conn.connect();
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            sb = new StringBuilder();
            line = null;
            while ((line = rd.readLine()) != null) {
                sb.append(line + '\n');
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
            rd = null;
            sb = null;
            conn = null;
        }
    }
}

