/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.adapter.ui;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.chiba.adapter.ui.UIGenerator;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xslt.TransformerService;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class XSLTGenerator
implements UIGenerator {
    private static Logger LOGGER = Logger.getLogger(XSLTGenerator.class);
    private Source source = null;
    private Result result = null;
    private HashMap parameters = null;
    private TransformerService transformerService = null;
    private URI stylesheetURI = null;
    private HashMap properties = null;

    public void setInput(Object input) {
        this.source = this.createInputSource(input);
    }

    public void setOutput(Object output) {
        this.result = this.createOutputResult(output);
    }

    public Object getParameter(String name) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(name);
    }

    public void setParameter(String name, Object value) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.parameters.put(name, value);
    }

    public void generate() throws XFormsException {
        try {
            if (this.transformerService == null) {
                throw new IllegalStateException("transformer service missing");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("generate: using stylesheet at " + this.stylesheetURI));
            }
            Transformer transformer = this.transformerService.getTransformer(this.stylesheetURI);
            this.prepareTransformer(transformer);
            long start = 0L;
            if (LOGGER.isDebugEnabled()) {
                start = System.currentTimeMillis();
            }
            transformer.transform(this.source, this.result);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("generate: transformation needed " + (System.currentTimeMillis() - start) + " ms"));
            }
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }

    public TransformerService getTransformerService() {
        return this.transformerService;
    }

    public void setTransformerService(TransformerService transformerService) {
        this.transformerService = transformerService;
    }

    public URI getStylesheetURI() {
        return this.stylesheetURI;
    }

    public void setStylesheetURI(URI stylesheetURI) {
        this.stylesheetURI = stylesheetURI;
    }

    public String getOutputProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return (String)this.properties.get(name);
    }

    public void setOutputProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(name, value);
    }

    protected Transformer prepareTransformer(Transformer transformer) {
        String value;
        if (this.properties != null) {
            for (String name : this.properties.keySet()) {
                value = (String)this.properties.get(name);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("prepare: setting output property " + name + "=" + value));
                }
                transformer.setOutputProperty(name, value);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"prepare: no output properties to be set");
        }
        if (this.parameters != null) {
            for (String name : this.parameters.keySet()) {
                value = this.parameters.get(name);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("prepare: setting stylesheet parameter " + name + "=" + value));
                }
                transformer.setParameter(name, value);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"prepare: no stylesheet parameters to be set");
        }
        return transformer;
    }

    protected Source createInputSource(Object input) {
        if (input == null) {
            throw new NullPointerException("parameter 'input' must not be null");
        }
        if (input instanceof Node) {
            return new DOMSource((Node)input);
        }
        if (input instanceof InputSource) {
            return new SAXSource((InputSource)input);
        }
        if (input instanceof InputStream) {
            return new StreamSource((InputStream)input);
        }
        if (input instanceof Reader) {
            return new StreamSource((Reader)input);
        }
        if (input instanceof File) {
            return new StreamSource((File)input);
        }
        throw new IllegalArgumentException(input.getClass().getName() + " not supported as input");
    }

    protected Result createOutputResult(Object output) {
        if (output == null) {
            throw new NullPointerException("parameter 'output' must not be null");
        }
        if (output instanceof Node) {
            return new DOMResult((Node)output);
        }
        if (output instanceof ContentHandler) {
            return new SAXResult((ContentHandler)output);
        }
        if (output instanceof OutputStream) {
            return new StreamResult((OutputStream)output);
        }
        if (output instanceof Writer) {
            return new StreamResult((Writer)output);
        }
        if (output instanceof File) {
            return new StreamResult((File)output);
        }
        throw new IllegalArgumentException(output.getClass().getName() + " not supported as output");
    }
}

