/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.base;

import java.net.URI;
import java.net.URISyntaxException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLBaseResolver {
    public static String resolveXMLBase(Node start, String relURI) throws URISyntaxException {
        return XMLBaseResolver.resolveXMLBase(start, relURI, false);
    }

    private static String getBase(Element e) {
        if (e.hasAttributeNS("http://www.w3.org/XML/1998/namespace", "base")) {
            return e.getAttributeNS("http://www.w3.org/XML/1998/namespace", "base");
        }
        return "";
    }

    private static String resolveXMLBase(Node start, String relURI, boolean base) throws URISyntaxException {
        if (relURI == null) {
            throw new URISyntaxException(relURI, "is not a valid URI");
        }
        URI uri = new URI(relURI);
        if (uri.isAbsolute()) {
            return uri.toString();
        }
        if (uri.isOpaque()) {
            return uri.toString();
        }
        Node n = start.getParentNode();
        if (n.getNodeType() == 9) {
            String baseFragment = XMLBaseResolver.getBase(((Document)n).getDocumentElement());
            String result = baseFragment + uri.normalize().toString();
            URI resolvedUri = new URI(result);
            if (resolvedUri.isAbsolute()) {
                return resolvedUri.normalize().toString();
            }
            if (base || baseFragment.length() > 0) {
                throw new URISyntaxException(resolvedUri.toString(), "no absolute URI");
            }
            return resolvedUri.normalize().toString();
        }
        if (n.getNodeType() == 1) {
            Element e = (Element)n;
            String baseFragment = XMLBaseResolver.getBase(e);
            URI parentURI = new URI(baseFragment);
            return XMLBaseResolver.resolveXMLBase(e, parentURI.resolve(uri.toString()).toString(), base || baseFragment.length() > 0);
        }
        throw new URISyntaxException(relURI, "could not resolve to absolute URI");
    }
}

