/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.events.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.NodeImpl;
import org.chiba.xml.events.DefaultAction;
import org.chiba.xml.events.XMLEvent;
import org.chiba.xml.events.XMLEventFactory;
import org.chiba.xml.events.XMLEventInitializer;
import org.chiba.xml.events.XMLEventService;
import org.chiba.xml.events.impl.XercesXMLEvent;
import org.chiba.xml.xforms.XFormsElement;
import org.w3c.dom.events.EventTarget;

public class DefaultXMLEventService
implements XMLEventService {
    private static Logger LOGGER = Logger.getLogger(DefaultXMLEventService.class);
    private XMLEventFactory eventFactory;
    private XMLEventInitializer eventInitializer;
    private Map defaultActions;

    public XMLEventFactory getXMLEventFactory() {
        return this.eventFactory;
    }

    public void setXMLEventFactory(XMLEventFactory eventFactory) {
        this.eventFactory = eventFactory;
    }

    public XMLEventInitializer getXMLEventInitializer() {
        return this.eventInitializer;
    }

    public void setXMLEventInitializer(XMLEventInitializer eventInitializer) {
        this.eventInitializer = eventInitializer;
    }

    public void registerDefaultAction(EventTarget target, String type, DefaultAction action) {
        HashMap<String, DefaultAction> types;
        if (target == null || type == null || action == null) {
            return;
        }
        if (this.defaultActions == null) {
            this.defaultActions = new HashMap();
        }
        if ((types = (HashMap<String, DefaultAction>)this.defaultActions.get(target)) == null) {
            types = new HashMap<String, DefaultAction>();
            this.defaultActions.put(target, types);
        }
        types.put(type, action);
    }

    public void deregisterDefaultAction(EventTarget target, String type, DefaultAction action) {
        if (target == null || type == null || action == null) {
            return;
        }
        if (this.defaultActions == null) {
            return;
        }
        Map types = (Map)this.defaultActions.get(target);
        if (types == null) {
            return;
        }
        DefaultAction current = (DefaultAction)types.get(type);
        if (current == null || !current.equals(action)) {
            return;
        }
        types.remove(type);
        if (types.isEmpty()) {
            this.defaultActions.remove(target);
            if (this.defaultActions.isEmpty()) {
                this.defaultActions = null;
            }
        }
    }

    public boolean dispatch(EventTarget target, String type, boolean bubbles, boolean cancelable, Object context) {
        DefaultAction action;
        if (LOGGER.isDebugEnabled()) {
            if (target instanceof NodeImpl) {
                NodeImpl node = (NodeImpl)target;
                Object object = node.getUserData();
                if (object instanceof XFormsElement) {
                    LOGGER.debug((Object)("dispatch event: " + type + " to " + ((XFormsElement)object).toString()));
                }
            } else {
                LOGGER.debug((Object)("dispatch event: " + type + " to " + target));
            }
        }
        XMLEvent event = this.eventFactory.createXMLEvent(type);
        this.eventInitializer.initXMLEvent(event, type, bubbles, cancelable, context);
        long start = System.currentTimeMillis();
        boolean preventDefault = target.dispatchEvent(event);
        long end = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("dispatch event: " + type + " handling needed " + (end - start) + " ms"));
        }
        if (!(event.getCancelable() && preventDefault || (action = this.lookup(target, type)) == null)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("dispatch event: " + type + " default action at " + action));
            }
            ((XercesXMLEvent)event).eventPhase = (short)4;
            start = System.currentTimeMillis();
            action.performDefault(event);
            end = System.currentTimeMillis();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("dispatch event: " + type + " default action needed " + (end - start) + " ms"));
            }
        }
        return preventDefault;
    }

    protected DefaultAction lookup(EventTarget target, String type) {
        if (this.defaultActions == null) {
            return null;
        }
        Map types = (Map)this.defaultActions.get(target);
        if (types == null) {
            return null;
        }
        return (DefaultAction)types.get(type);
    }
}

