/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.ns;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamespaceResolver {
    public static Map getAllNamespaces(Element context) {
        HashMap map = new HashMap();
        NamespaceResolver.getAllNamespaces(context, map);
        return map;
    }

    public static String getNamespaceURI(Element context, String prefix) {
        NamedNodeMap attrs = context.getAttributes();
        for (int c = 0; c < attrs.getLength(); ++c) {
            Node attr = attrs.item(c);
            if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
            if (attr.getPrefix() == null && (prefix == null || prefix.length() == 0)) {
                return attr.getNodeValue();
            }
            if (!"xmlns".equals(attr.getPrefix()) || !attr.getLocalName().equals(prefix)) continue;
            return attr.getNodeValue();
        }
        Node n = context.getParentNode();
        if (n != null && n.getNodeType() == 1) {
            return NamespaceResolver.getNamespaceURI((Element)n, prefix);
        }
        return null;
    }

    public static String getPrefix(Element context, String uri) {
        if (uri.equals(context.getNamespaceURI())) {
            return context.getPrefix();
        }
        NamedNodeMap attrs = context.getAttributes();
        for (int c = 0; c < attrs.getLength(); ++c) {
            Node attr = attrs.item(c);
            if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
            if (attr.getPrefix() == null && attr.getNodeValue().equals(uri)) {
                return "";
            }
            if (!"xmlns".equals(attr.getPrefix()) || !attr.getNodeValue().equals(uri)) continue;
            return attr.getLocalName();
        }
        Node n = context.getParentNode();
        if (n != null && n.getNodeType() == 1) {
            return NamespaceResolver.getPrefix((Element)n, uri);
        }
        return null;
    }

    public static void applyNamespaces(Element context, Element candidate) {
        NamedNodeMap attrs = context.getAttributes();
        for (int c = 0; c < attrs.getLength(); ++c) {
            Node attr = attrs.item(c);
            if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || candidate.hasAttributeNS("http://www.w3.org/2000/xmlns/", attr.getLocalName())) continue;
            candidate.setAttributeNS("http://www.w3.org/2000/xmlns/", attr.getNodeName(), attr.getNodeValue());
        }
        Node n = context.getParentNode();
        if (n != null && n.getNodeType() == 1) {
            NamespaceResolver.applyNamespaces((Element)n, candidate);
        }
    }

    public static String getExpandedName(Element context, String name) {
        int separator = name.indexOf(58);
        String prefix = separator > -1 ? name.substring(0, separator) : null;
        String localName = separator > -1 ? name.substring(separator + 1) : name;
        String namespaceURI = prefix != null ? NamespaceResolver.getNamespaceURI(context, prefix) : null;
        return NamespaceResolver.expand(namespaceURI, localName);
    }

    public static String expand(String namespaceURI, String localName) {
        StringBuffer buffer = new StringBuffer();
        if (namespaceURI != null) {
            buffer.append('{');
            buffer.append(namespaceURI);
            buffer.append('}');
        }
        buffer.append(localName);
        return buffer.toString();
    }

    private static void getAllNamespaces(Element context, Map namespaces) {
        NamedNodeMap attrs = context.getAttributes();
        for (int c = 0; c < attrs.getLength(); ++c) {
            String prefix;
            Node attr = attrs.item(c);
            if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
            String string = prefix = attr.getPrefix() == null ? "" : attr.getLocalName();
            if (namespaces.get(prefix) != null) continue;
            namespaces.put(prefix, attr.getNodeValue());
        }
        Node n = context.getParentNode();
        if (n != null && n.getNodeType() == 1) {
            NamespaceResolver.getAllNamespaces((Element)n, namespaces);
        }
    }
}

