/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.xs.XSModel;
import org.chiba.xml.events.impl.DefaultXMLEventInitializer;
import org.chiba.xml.events.impl.DefaultXMLEventService;
import org.chiba.xml.events.impl.XercesXMLEventFactory;
import org.chiba.xml.xforms.Container;
import org.chiba.xml.xforms.XFormsElement;
import org.chiba.xml.xforms.config.Config;
import org.chiba.xml.xforms.config.XFormsConfigException;
import org.chiba.xml.xforms.connector.ConnectorFactory;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.AbstractFormControl;
import org.chiba.xml.xforms.ui.Repeat;
import org.chiba.xml.xforms.ui.Upload;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ChibaBean
implements Serializable {
    private static Logger LOGGER = Logger.getLogger(ChibaBean.class);
    private static String APP_INFO = null;
    private Container container = null;
    private String baseURI = null;
    private Map context = null;

    public ChibaBean() {
        LOGGER.info((Object)ChibaBean.getAppInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAppInfo() {
        Class<ChibaBean> clazz = ChibaBean.class;
        synchronized (ChibaBean.class) {
            if (APP_INFO == null) {
                try {
                    int c;
                    BufferedInputStream stream = new BufferedInputStream(ChibaBean.class.getResourceAsStream("version.info"));
                    StringBuffer buffer = new StringBuffer("Chiba/");
                    while ((c = stream.read()) > -1) {
                        if (c == 10 || c == 13) continue;
                        buffer.append((char)c);
                    }
                    stream.close();
                    APP_INFO = buffer.toString();
                }
                catch (IOException e) {
                    APP_INFO = "Chiba";
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return APP_INFO;
        }
    }

    public void setConfig(String path) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("set config: " + path));
        }
        if (path == null || !new File(path).exists()) {
            throw new XFormsConfigException("path not found: " + path);
        }
        Config.getInstance(path);
    }

    public void setBaseURI(String uri) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("set base uri: " + uri));
        }
        this.baseURI = uri;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setContext(Map context) {
        this.context = context;
    }

    public Map getContext() {
        if (this.context == null) {
            this.context = new HashMap();
        }
        return this.context;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setXMLContainer(Node node) throws XFormsException {
        this.ensureContainerNotInitialized();
        Document document = this.toDocument(node);
        this.createContainer().setDocument(document);
    }

    public void setXMLContainer(Node node, XSModel externalSchema) throws XFormsException {
        this.ensureContainerNotInitialized();
        Document document = this.toDocument(node);
        this.createContainer().setDocument(document);
        this.container.setExternalSchema(externalSchema);
    }

    public void setXMLContainer(URI uri) throws XFormsException {
        this.ensureContainerNotInitialized();
        String absoluteURI = this.resolve(uri);
        ConnectorFactory connectorFactory = ConnectorFactory.getFactory();
        connectorFactory.setContext(this.getContext());
        Node node = (Node)connectorFactory.createURIResolver(absoluteURI, null).resolve();
        Document document = this.toDocument(node);
        this.createContainer().setDocument(document);
    }

    public void setXMLContainer(InputStream stream) throws XFormsException {
        Document document;
        this.ensureContainerNotInitialized();
        try {
            document = this.getDocumentBuilder().parse(stream);
        }
        catch (Exception e) {
            throw new XFormsException("could not create document container", e);
        }
        this.createContainer().setDocument(document);
    }

    public void setXMLContainer(InputSource source) throws XFormsException {
        Document document;
        this.ensureContainerNotInitialized();
        try {
            document = this.getDocumentBuilder().parse(source);
        }
        catch (Exception e) {
            throw new XFormsException("could not create document container", e);
        }
        this.createContainer().setDocument(document);
    }

    public Document getXMLContainer() throws XFormsException {
        this.ensureContainerPresent();
        return this.container.getDocument();
    }

    public Document getInstanceDocument(String id) throws DOMException {
        try {
            this.ensureContainerInitialized();
        }
        catch (XFormsException e) {
            throw new DOMException(11, "Processor is not intialized");
        }
        List models = this.container.getModels();
        Document instance = null;
        int i = 0;
        while (i < models.size()) {
            Model model = (Model)models.get(i);
            instance = model.getInstanceDocument(id);
            if (instance != null) {
                return instance;
            }
            ++i;
        }
        throw new DOMException(8, "Instance with id: '" + id + "' not found");
    }

    public void init() throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"init");
        }
        this.ensureContainerPresent();
        this.ensureContainerNotInitialized();
        this.container.init();
    }

    public boolean dispatch(String id, String event) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("dispatch: id: " + id + ", event: " + event));
        }
        this.ensureContainerPresent();
        this.ensureContainerInitialized();
        return this.container.dispatch(id, event);
    }

    public final boolean hasControlChanged(String id, String value) throws XFormsException {
        this.ensureContainerPresent();
        this.ensureContainerInitialized();
        XFormsElement element = this.container.lookup(id);
        if (element == null || !(element instanceof AbstractFormControl)) {
            throw new XFormsException("id '" + id + "' does not identify a form control");
        }
        AbstractFormControl control = (AbstractFormControl)element;
        String controlValue = control.getValue();
        if (controlValue == null) {
            return false;
        }
        return !controlValue.equals(value);
    }

    public final boolean hasControlType(String id, String type) throws XFormsException {
        this.ensureContainerPresent();
        this.ensureContainerInitialized();
        XFormsElement element = this.container.lookup(id);
        if (element == null || !(element instanceof AbstractFormControl)) {
            throw new XFormsException("id '" + id + "' does not identify a form control");
        }
        String datatype = ((AbstractFormControl)element).getDatatype();
        if (datatype != null) {
            return element.getModel().getValidator().isRestricted(type, datatype);
        }
        return false;
    }

    public final void updateControlValue(String id, String value) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("update control value: id: " + id + ", value: " + value));
        }
        this.ensureContainerPresent();
        this.ensureContainerInitialized();
        XFormsElement element = this.container.lookup(id);
        if (element == null || !(element instanceof AbstractFormControl)) {
            throw new XFormsException("id '" + id + "' does not identify a form control");
        }
        if (element instanceof Upload) {
            throw new XFormsException("upload cannot be updated with this method");
        }
        AbstractFormControl control = (AbstractFormControl)element;
        control.setValue(value);
    }

    public final void updateControlValue(String id, String mediatype, String filename, byte[] data) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("update control value: id: " + id + ", mediatype: " + mediatype + ", filename: " + filename + ", data: " + (data != null ? String.valueOf(data.length) + " bytes" : "null")));
        }
        this.ensureContainerPresent();
        this.ensureContainerInitialized();
        XFormsElement element = this.container.lookup(id);
        if (element == null || !(element instanceof Upload)) {
            throw new XFormsException("id '" + id + "' does not identify an upload control");
        }
        Upload upload = (Upload)element;
        upload.setValue(data, filename, mediatype);
    }

    public void updateRepeatIndex(String id, int index) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("update repeat index: id: " + id + ", index: " + index));
        }
        this.ensureContainerPresent();
        this.ensureContainerInitialized();
        XFormsElement element = this.container.lookup(id);
        if (element == null || !(element instanceof Repeat)) {
            throw new XFormsException("id '" + id + "' does not identify a repeat");
        }
        Repeat repeat = (Repeat)element;
        repeat.setIndex(index);
        Model model = repeat.getModel();
        this.container.dispatch(model.getTarget(), "xforms-rebuild", null);
        this.container.dispatch(model.getTarget(), "xforms-recalculate", null);
        this.container.dispatch(model.getTarget(), "xforms-revalidate", null);
        this.container.dispatch(model.getTarget(), "xforms-refresh", null);
    }

    public void shutdown() throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"shutdown");
        }
        if (this.container != null) {
            this.container.shutdown();
            this.container = null;
        } else {
            LOGGER.warn((Object)"shutdown: container not present");
        }
    }

    private Container createContainer() {
        DefaultXMLEventService eventService = new DefaultXMLEventService();
        eventService.setXMLEventFactory(new XercesXMLEventFactory());
        eventService.setXMLEventInitializer(new DefaultXMLEventInitializer());
        this.container = new Container(this);
        this.container.setXMLEventService(eventService);
        return this.container;
    }

    private Document toDocument(Node node) throws XFormsException {
        if (node instanceof DocumentImpl) {
            return (Document)node;
        }
        Document document = this.getDocumentBuilder().newDocument();
        if (node instanceof Document) {
            node = ((Document)node).getDocumentElement();
        }
        document.appendChild(document.importNode(node, true));
        return document;
    }

    private DocumentBuilder getDocumentBuilder() throws XFormsException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setAttribute("http://apache.org/xml/properties/dom/document-class-name", "org.apache.xerces.dom.DocumentImpl");
            return factory.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }

    private void ensureContainerPresent() throws XFormsException {
        if (this.container == null) {
            throw new XFormsException("document container not present");
        }
    }

    private void ensureContainerInitialized() throws XFormsException {
        if (this.container == null || !this.container.isModelConstructDone()) {
            throw new XFormsException("document container not initialized");
        }
    }

    private void ensureContainerNotInitialized() throws XFormsException {
        if (this.container != null && this.container.isModelConstructDone()) {
            throw new XFormsException("document container already initialized");
        }
    }

    private String resolve(URI relative) throws XFormsException {
        if (relative.isAbsolute() || relative.isOpaque()) {
            return relative.toString();
        }
        if (this.baseURI == null) {
            throw new XFormsException("base uri not present");
        }
        try {
            return new URI(this.baseURI).resolve(relative).toString();
        }
        catch (URISyntaxException e) {
            throw new XFormsException(e);
        }
    }
}

