/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.NodeImpl;
import org.chiba.xml.ns.NamespaceResolver;
import org.chiba.xml.xforms.Container;
import org.chiba.xml.xforms.XFormsConstants;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.BoundElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public abstract class XFormsElement
implements XFormsConstants {
    protected Container container = null;
    protected Element element = null;
    protected EventTarget target = null;
    protected Model model = null;
    protected String id;
    protected String originalId;
    protected String xformsPrefix = null;

    public XFormsElement(Element element) {
        this.element = element;
        this.target = (EventTarget)((Object)element);
        this.container = this.getContainerObject();
        this.xformsPrefix = NamespaceResolver.getPrefix(this.element, "http://www.w3.org/2002/xforms");
        if (this.element.hasAttributeNS(null, "id")) {
            this.id = this.element.getAttributeNS(null, "id");
        } else {
            this.id = this.container.generateId();
            this.element.setAttributeNS(null, "id", this.id);
        }
        this.register();
    }

    public XFormsElement(Element element, Model model) {
        this(element);
        this.model = model;
    }

    public abstract void init() throws XFormsException;

    public abstract void dispose() throws XFormsException;

    public Container getContainerObject() {
        return (Container)((ElementImpl)this.element.getOwnerDocument().getDocumentElement()).getUserData();
    }

    public Element getElement() {
        return this.element;
    }

    public String getId() {
        return this.id;
    }

    public Model getModel() {
        return this.model;
    }

    public XFormsElement getParentObject() {
        return (XFormsElement)((ElementImpl)this.element.getParentNode()).getUserData();
    }

    public EventTarget getTarget() {
        return this.target;
    }

    public String getXFormsAttribute(String name) {
        return XFormsElement.getXFormsAttribute(this.element, name);
    }

    public static String getXFormsAttribute(Element element, String name) {
        if (element.hasAttributeNS("http://www.w3.org/2002/xforms", name)) {
            return element.getAttributeNS("http://www.w3.org/2002/xforms", name);
        }
        if (element.hasAttributeNS(null, name)) {
            return element.getAttributeNS(null, name);
        }
        return null;
    }

    public void register() {
        this.container.register(this);
        if (this.originalId != null) {
            String tmpId = this.id;
            this.id = this.originalId;
            this.container.register(this);
            this.id = tmpId;
        }
    }

    public void deregister() {
        this.container.deregister(this);
    }

    public void setGeneratedId(String generatedId) throws XFormsException {
        this.originalId = this.id;
        this.id = generatedId;
        this.element.setAttributeNS(null, "id", this.id);
        if (this.model.isReady()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("originalId", this.originalId);
            this.container.dispatch(this.target, "chiba-id-generated", map);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof XFormsElement)) {
            return false;
        }
        return ((XFormsElement)object).getId().equals(this.getId());
    }

    public String toString() {
        return "[" + this.getElement().getNodeName() + ":" + this.id + "]";
    }

    protected abstract Logger getLogger();

    protected boolean isCancelled(Event event) {
        String s;
        return event.getCancelable() && this.element.hasAttributeNS("http://www.w3.org/2001/xml-events", "event") && (s = this.element.getAttributeNS("http://www.w3.org/2001/xml-events", "event")).equals(event.getType()) && this.element.getAttributeNS("http://www.w3.org/2001/xml-events", "defaultAction").equals("cancel");
    }

    protected String getParentContextPath(Node start) {
        String result = null;
        NodeImpl parent = (NodeImpl)start.getParentNode();
        if (parent == null) {
            return null;
        }
        Object o = parent.getUserData();
        if (o instanceof XFormsElement) {
            XFormsElement xCurrent = (XFormsElement)parent.getUserData();
            if (xCurrent == null) {
                this.getParentContextPath((Node)parent);
            }
            if (xCurrent instanceof BoundElement) {
                if (((BoundElement)xCurrent).isBound()) {
                    String locationPath = ((BoundElement)xCurrent).getLocationPath();
                    return locationPath;
                }
                result = this.getParentContextPath(parent.getParentNode());
            }
        } else {
            return this.getParentContextPath((Node)parent);
        }
        return result;
    }
}

