/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.action;

import org.apache.commons.jxpath.JXPathContext;
import org.apache.log4j.Logger;
import org.chiba.xml.xforms.action.AbstractBoundAction;
import org.chiba.xml.xforms.core.Instance;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.exception.XFormsBindingException;
import org.chiba.xml.xforms.exception.XFormsException;
import org.w3c.dom.Element;

public class DeleteAction
extends AbstractBoundAction {
    private static Logger LOGGER = Logger.getLogger(DeleteAction.class);
    private String atAttribute;

    public DeleteAction(Element element, Model model) {
        super(element, model);
    }

    public void init() throws XFormsException {
        super.init();
        this.atAttribute = this.getXFormsAttribute("at");
        if (this.atAttribute == null) {
            throw new XFormsBindingException("missing at attribute at " + this, this.target, null);
        }
    }

    public String getBindingExpression() {
        return this.getXFormsAttribute("nodeset");
    }

    public void perform() throws XFormsException {
        String path;
        String pathExpression;
        Instance instance = this.model.getInstance(this.getInstanceId());
        int contextSize = instance.countNodeset(pathExpression = this.getLocationPath());
        if (contextSize == 0) {
            this.getLogger().warn((Object)(this + " perform: nodeset '" + pathExpression + "' is empty"));
            return;
        }
        if (this.atAttribute.equals("last()")) {
            path = new StringBuffer(pathExpression).append('[').append(contextSize).append(']').toString();
        } else {
            JXPathContext context = instance.getInstanceContext();
            boolean lenient = context.isLenient();
            context.setLenient(true);
            context.getPointer(pathExpression + "[chiba:declare('delete-position', " + this.atAttribute + ")]");
            context.setLenient(lenient);
            double value = (Double)context.getValue("number(chiba:undeclare('delete-position'))");
            long position = Math.round(value);
            if (Double.isNaN(value) || position < 1L || position > (long)contextSize) {
                this.getLogger().warn((Object)(this + " perform: expression '" + this.atAttribute + "' does not point to an existing node"));
                return;
            }
            path = new StringBuffer(pathExpression).append('[').append(position).append(']').toString();
        }
        instance.deleteNode(path);
        this.container.dispatch(instance.getTarget(), "xforms-delete", (Object)path);
        this.doRebuild(true);
        this.doRecalculate(true);
        this.doRevalidate(true);
        this.doRefresh(true);
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

