/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.action;

import org.apache.commons.jxpath.JXPathContext;
import org.apache.log4j.Logger;
import org.chiba.xml.xforms.action.AbstractBoundAction;
import org.chiba.xml.xforms.core.Instance;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.exception.XFormsBindingException;
import org.chiba.xml.xforms.exception.XFormsException;
import org.w3c.dom.Element;

public class InsertAction
extends AbstractBoundAction {
    private static Logger LOGGER = Logger.getLogger(InsertAction.class);
    private String atAttribute;
    private String positionAttribute;

    public InsertAction(Element element, Model model) {
        super(element, model);
    }

    public void init() throws XFormsException {
        super.init();
        this.atAttribute = this.getXFormsAttribute("at");
        if (this.atAttribute == null) {
            throw new XFormsBindingException("missing at attribute at " + this, this.target, null);
        }
        this.positionAttribute = this.getXFormsAttribute("position");
        if (this.positionAttribute == null) {
            throw new XFormsBindingException("missing position attribute at " + this, this.target, null);
        }
    }

    public String getBindingExpression() {
        return this.getXFormsAttribute("nodeset");
    }

    public void perform() throws XFormsException {
        long position;
        String pathExpression;
        Instance instance = this.model.getInstance(this.getInstanceId());
        int contextSize = instance.countNodeset(pathExpression = this.getLocationPath());
        if (contextSize == 0) {
            this.getLogger().warn((Object)(this + " perform: nodeset '" + pathExpression + "' is empty"));
            return;
        }
        if (this.atAttribute.equals("last()")) {
            position = contextSize;
            if (this.positionAttribute.equals("after")) {
                ++position;
            }
        } else {
            JXPathContext context = instance.getInstanceContext();
            boolean lenient = context.isLenient();
            context.setLenient(true);
            context.getPointer(pathExpression + "[chiba:declare('insert-position', number(" + this.atAttribute + "))]");
            context.setLenient(lenient);
            double value = (Double)context.getValue("number(chiba:undeclare('insert-position'))");
            position = Math.round(value);
            if (position < 1L) {
                position = 1L;
            }
            if (position > (long)contextSize) {
                position = contextSize;
            }
            if (this.positionAttribute.equals("after")) {
                ++position;
            }
            if (Double.isNaN(value)) {
                position = contextSize + 1;
            }
        }
        String origin = new StringBuffer(pathExpression).append('[').append(contextSize).append(']').toString();
        String before = new StringBuffer(pathExpression).append('[').append(position).append(']').toString();
        instance.insertNode(origin, before);
        this.container.dispatch(instance.getTarget(), "xforms-insert", (Object)before);
        this.doRebuild(true);
        this.doRecalculate(true);
        this.doRevalidate(true);
        this.doRefresh(true);
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

