/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.action;

import org.apache.commons.jxpath.JXPathContext;
import org.apache.log4j.Logger;
import org.chiba.xml.xforms.XFormsElement;
import org.chiba.xml.xforms.action.AbstractBoundAction;
import org.chiba.xml.xforms.core.Instance;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.exception.XFormsBindingException;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.Repeat;
import org.w3c.dom.Element;

public class SetIndexAction
extends AbstractBoundAction {
    private static Logger LOGGER = Logger.getLogger(SetIndexAction.class);
    private String indexAttribute;
    private String repeatAttribute;

    public SetIndexAction(Element element, Model model) {
        super(element, model);
    }

    public void init() throws XFormsException {
        super.init();
        this.repeatAttribute = this.getXFormsAttribute("repeat");
        if (this.repeatAttribute == null) {
            throw new XFormsBindingException("missing repeat attribute at " + this, this.target, null);
        }
        this.indexAttribute = this.getXFormsAttribute("index");
        if (this.indexAttribute == null) {
            throw new XFormsBindingException("missing index attribute at " + this, this.target, null);
        }
    }

    public void perform() throws XFormsException {
        XFormsElement repeatObject = this.container.lookup(this.repeatAttribute);
        if (repeatObject == null || !(repeatObject instanceof Repeat)) {
            throw new XFormsBindingException("invalid repeat id at " + this, this.target, (Object)this.repeatAttribute);
        }
        Repeat repeat = (Repeat)repeatObject;
        Instance instance = this.model.getInstance(this.getInstanceId());
        String pathExpression = this.getLocationPath();
        JXPathContext context = instance.getInstanceContext();
        boolean lenient = context.isLenient();
        context.setLenient(true);
        context.getPointer(pathExpression + "[chiba:declare('repeat-index', " + this.indexAttribute + ")]");
        context.setLenient(lenient);
        double value = (Double)context.getValue("number(chiba:undeclare('repeat-index'))");
        if (Double.isNaN(value)) {
            this.getLogger().warn((Object)(this + " perform: expression '" + this.indexAttribute + "' does not evaluate to an integer"));
            return;
        }
        long index = Math.round(value);
        if (index < 1L) {
            repeat.setIndex(1);
            this.container.dispatch(repeat.getTarget(), "xforms-scroll-first", null);
        } else if (index > (long)repeat.getContextSize()) {
            index = repeat.getContextSize();
            repeat.setIndex((int)index);
            this.container.dispatch(repeat.getTarget(), "xforms-scroll-last", null);
        } else {
            repeat.setIndex((int)index);
        }
        this.doRebuild(true);
        this.doRecalculate(true);
        this.doRevalidate(true);
        this.doRefresh(true);
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

