/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.config;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.chiba.xml.xforms.config.Config;
import org.chiba.xml.xforms.config.XFormsConfigException;
import org.chiba.xml.xforms.connector.InstanceSerializer;
import org.chiba.xml.xforms.connector.InstanceSerializerMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultConfig
extends Config {
    public DefaultConfig(InputStream stream) throws XFormsConfigException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            Document document = factory.newDocumentBuilder().parse(stream);
            JXPathContext context = JXPathContext.newContext((Object)document.getDocumentElement());
            this.properties = this.load(context, "/properties/property", "name", "value");
            this.stylesheets = this.load(context, "/stylesheets/stylesheet", "name", "value");
            this.uriResolvers = this.load(context, "/connectors/uri-resolver", "scheme", "class");
            this.submissionHandlers = this.load(context, "/connectors/submission-handler", "scheme", "class");
            this.errorMessages = this.load(context, "/error-messages/message", "id", "value");
            this.extensionFunctions = this.loadExtensionFunctions(context, "/extension-functions/function");
            this.customElements = this.loadCustomElements(context, "/custom-elements/element");
            this.connectorFactory = this.load(context, "/connectors", "factoryClass");
            this.instanceSerializerMap = this.loadSerializer(context, "/register-serializer/instance-serializer", "scheme", "method", "mediatype", "class");
        }
        catch (Exception e) {
            throw new XFormsConfigException(e);
        }
    }

    private HashMap load(JXPathContext configContext, String sectionPath, String nameAttribute, String valueAttribute) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator iterator = configContext.iteratePointers(sectionPath);
        while (iterator.hasNext()) {
            Pointer pointer = (Pointer)iterator.next();
            Element element = (Element)pointer.getNode();
            map.put(element.getAttribute(nameAttribute), element.getAttribute(valueAttribute));
        }
        return map;
    }

    private InstanceSerializerMap loadSerializer(JXPathContext configContext, String sectionPath, String scheme, String method, String mediatype, String serializerClass) throws Exception {
        InstanceSerializerMap map = new InstanceSerializerMap();
        Iterator iterator = configContext.iteratePointers(sectionPath);
        while (iterator.hasNext()) {
            Pointer pointer = (Pointer)iterator.next();
            Element element = (Element)pointer.getNode();
            try {
                String schemeVal = element.getAttribute(scheme);
                schemeVal = "".equals(schemeVal) ? "*" : schemeVal;
                String methodVal = element.getAttribute(method);
                methodVal = "".equals(methodVal) ? "*" : methodVal;
                String mediatypeVal = element.getAttribute(mediatype);
                mediatypeVal = "".equals(mediatypeVal) ? "*" : mediatypeVal;
                String classVal = element.getAttribute(serializerClass);
                if (classVal == null) continue;
                InstanceSerializer serializer = (InstanceSerializer)Class.forName(classVal).newInstance();
                map.registerSerializer(schemeVal, methodVal, mediatypeVal, serializer);
            }
            catch (Exception e) {
                LOGGER.error((Object)("registerSerializer(\"" + scheme + "\",\"" + method + "\"," + mediatype + "\",\"" + serializerClass + "\") failed: " + e.getMessage()), (Throwable)e);
            }
        }
        return map;
    }

    private HashMap loadExtensionFunctions(JXPathContext configContext, String sectionPath) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Iterator iterator = configContext.iteratePointers(sectionPath);
        while (iterator.hasNext()) {
            String key;
            Pointer pointer = (Pointer)iterator.next();
            Element element = (Element)pointer.getNode();
            String namespace = element.getAttribute("namespace");
            namespace = "".equals(namespace) ? null : namespace;
            String function = element.getAttribute("name");
            function = "".equals(function) ? null : function;
            String functionClass = element.getAttribute("class");
            String string = functionClass = "".equals(functionClass) ? null : functionClass;
            String string2 = namespace == null ? function : (key = namespace + (function == null ? "" : " " + function));
            if (function == null || functionClass == null) continue;
            String javaFunction = element.getAttribute("java-name");
            javaFunction = javaFunction == null || "".equalsIgnoreCase(javaFunction) ? function : javaFunction;
            String[] classFunction = new String[]{functionClass, javaFunction};
            if (key == null) continue;
            map.put(key, classFunction);
        }
        return map;
    }

    private HashMap loadCustomElements(JXPathContext configContext, String sectionPath) {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator iterator = configContext.iteratePointers(sectionPath);
        while (iterator.hasNext()) {
            String key;
            Pointer pointer = (Pointer)iterator.next();
            Element element = (Element)pointer.getNode();
            String namespace = element.getAttribute("namespace");
            namespace = "".equals(namespace) ? null : namespace;
            String elementName = element.getAttribute("name");
            elementName = "".equals(elementName) ? null : elementName;
            String elementClass = element.getAttribute("class");
            String string = elementClass = "".equals(elementClass) ? null : elementClass;
            String string2 = namespace == null ? elementName : (key = namespace + (elementName == null ? "" : ":" + elementName));
            if (elementName == null || elementClass == null || key == null) continue;
            map.put(key, elementClass);
        }
        return map;
    }

    private String load(JXPathContext configContext, String path, String nameAttribute) throws Exception {
        Pointer pointer = configContext.getPointer(path);
        Element element = (Element)pointer.getNode();
        String value = element.getAttribute(nameAttribute);
        return value;
    }
}

