/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.connector;

import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import org.chiba.xml.xforms.config.Config;
import org.chiba.xml.xforms.connector.Connector;
import org.chiba.xml.xforms.connector.InstanceSerializer;
import org.chiba.xml.xforms.connector.InstanceSerializerMap;
import org.chiba.xml.xforms.connector.SchemaValidator;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.core.Submission;
import org.chiba.xml.xforms.exception.XFormsException;
import org.w3c.dom.Node;

public class AbstractConnector
implements Connector {
    private String uri;
    private String defaultEncoding = "UTF-8";
    private InstanceSerializerMap instanceSerializerMap;
    private Map context;

    public void setURI(String uri) {
        this.uri = uri;
    }

    public String getURI() {
        return this.uri;
    }

    public void registerSerializer(String scheme, String method, String mediatype, InstanceSerializer serializer) throws XFormsException {
        if (this.instanceSerializerMap == null) {
            Config config = Config.getInstance();
            this.instanceSerializerMap = new InstanceSerializerMap(config.getInstanceSerializerMap());
        }
        this.instanceSerializerMap.registerSerializer(scheme, method, mediatype, serializer);
    }

    public InstanceSerializer getSerializer(String scheme, String method, String mediatype) throws XFormsException {
        if (this.instanceSerializerMap == null) {
            Config config = Config.getInstance();
            this.instanceSerializerMap = new InstanceSerializerMap(config.getInstanceSerializerMap());
        }
        return this.instanceSerializerMap.getSerializer(scheme, method, mediatype);
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setContext(Map context) {
        this.context = context;
    }

    public Map getContext() {
        return this.context;
    }

    protected String getURIWithoutFragment() {
        if (this.uri == null) {
            return null;
        }
        int fragmentIndex = this.uri.indexOf(35);
        if (fragmentIndex == -1) {
            return this.uri;
        }
        return this.uri.substring(0, fragmentIndex);
    }

    protected final void serialize(Submission submission, Node instance, OutputStream stream) throws Exception {
        InstanceSerializer serializer;
        String method = submission.getMethod();
        if (method == null) {
            throw new XFormsException("Submission method not defined.");
        }
        URI uri = new URI(this.getURI());
        String scheme = uri.getScheme();
        String mediatype = submission.getMediatype();
        if (mediatype == null) {
            mediatype = "application/xml";
        }
        if ((serializer = this.getSerializer(scheme, method, mediatype)) == null) {
            throw new XFormsException("No instance serializer defined for scheme '" + scheme + "', method '" + method + "' and mediatype '" + mediatype + "'");
        }
        serializer.serialize(submission, instance, stream, this.getDefaultEncoding());
    }

    public boolean validateSchema(Submission submission, Node instance) throws XFormsException {
        Model model = submission.getModel();
        SchemaValidator validator = new SchemaValidator();
        return validator.validateSchema(model, instance);
    }
}

