/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.connector;

import java.util.HashMap;
import java.util.Map;
import org.chiba.xml.xforms.connector.InstanceSerializer;
import org.chiba.xml.xforms.connector.serializer.FormDataSerializer;
import org.chiba.xml.xforms.connector.serializer.MultipartRelatedSerializer;
import org.chiba.xml.xforms.connector.serializer.UrlEncodedSerializer;
import org.chiba.xml.xforms.connector.serializer.XMLSerializer;

public class InstanceSerializerMap {
    private Map serializerMap = new HashMap();

    public InstanceSerializerMap() {
        this.registerSerializer("http", "post", "*", new XMLSerializer());
        this.registerSerializer("https", "post", "*", new XMLSerializer());
        this.registerSerializer("mailto", "post", "*", new XMLSerializer());
        this.registerSerializer("file", "get", "*", new UrlEncodedSerializer());
        this.registerSerializer("http", "get", "*", new UrlEncodedSerializer());
        this.registerSerializer("https", "get", "*", new UrlEncodedSerializer());
        this.registerSerializer("file", "put", "*", new XMLSerializer());
        this.registerSerializer("http", "put", "*", new XMLSerializer());
        this.registerSerializer("https", "put", "*", new XMLSerializer());
        this.registerSerializer("http", "multipart-post", "*", new MultipartRelatedSerializer());
        this.registerSerializer("https", "multipart-post", "*", new MultipartRelatedSerializer());
        this.registerSerializer("mailto", "multipart-post", "*", new MultipartRelatedSerializer());
        this.registerSerializer("http", "form-data-post", "*", new FormDataSerializer());
        this.registerSerializer("https", "form-data-post", "*", new FormDataSerializer());
        this.registerSerializer("mailto", "form-data-post", "*", new FormDataSerializer());
        this.registerSerializer("http", "urlencoded-post", "*", new UrlEncodedSerializer());
        this.registerSerializer("https", "urlencoded-post", "*", new UrlEncodedSerializer());
        this.registerSerializer("mailto", "urlencoded-post", "*", new UrlEncodedSerializer());
        this.registerSerializer("echo", "*", "*", new XMLSerializer());
    }

    public InstanceSerializerMap(InstanceSerializerMap map) {
        this.serializerMap.putAll(map.serializerMap);
    }

    public void registerSerializer(String scheme, String method, String mediatype, InstanceSerializer serializer) {
        this.serializerMap.put(scheme + ":" + method + ":" + mediatype, serializer);
    }

    public InstanceSerializer getSerializer(String scheme, String method, String mediatype) {
        InstanceSerializer serializer = (InstanceSerializer)this.serializerMap.get(scheme + ":" + method + ":" + mediatype);
        if (serializer == null) {
            serializer = (InstanceSerializer)this.serializerMap.get(scheme + ":" + method + ":*");
        }
        if (serializer == null) {
            serializer = (InstanceSerializer)this.serializerMap.get(scheme + ":*:" + mediatype);
        }
        if (serializer == null) {
            serializer = (InstanceSerializer)this.serializerMap.get(scheme + ":*:*");
        }
        if (serializer == null) {
            serializer = (InstanceSerializer)this.serializerMap.get("*:" + method + ":" + mediatype);
        }
        if (serializer == null) {
            serializer = (InstanceSerializer)this.serializerMap.get("*:" + method + ":*");
        }
        if (serializer == null) {
            serializer = (InstanceSerializer)this.serializerMap.get("*:*:" + mediatype);
        }
        if (serializer == null) {
            serializer = (InstanceSerializer)this.serializerMap.get("*:*:*");
        }
        return serializer;
    }
}

