/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.connector.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.chiba.xml.dom.DOMUtil;
import org.chiba.xml.xforms.connector.AbstractConnector;
import org.chiba.xml.xforms.connector.SubmissionHandler;
import org.chiba.xml.xforms.connector.file.FileURIResolver;
import org.chiba.xml.xforms.core.Submission;
import org.chiba.xml.xforms.exception.XFormsException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FileSubmissionHandler
extends AbstractConnector
implements SubmissionHandler {
    private static final Logger LOGGER = Logger.getLogger(FileSubmissionHandler.class);

    public Map submit(Submission submission, Node instance) throws XFormsException {
        if (submission.getMethod().equalsIgnoreCase("get")) {
            try {
                InputStream inputStream;
                File file;
                URI uri = new URI(this.getURI());
                String fileName = uri.getSchemeSpecificPart();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("getting file '" + fileName + "'"));
                }
                if ((file = new File(fileName)).isDirectory()) {
                    Document document = FileURIResolver.buildDirectoryListing(file);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    DOMUtil.prettyPrintDOM(document, outputStream);
                    inputStream = new ByteArrayInputStream(outputStream.toByteArray());
                } else {
                    inputStream = new FileInputStream(new File(fileName));
                }
                HashMap<String, FileInputStream> response = new HashMap<String, FileInputStream>();
                response.put("chiba.submission.response.stream", (FileInputStream)inputStream);
                return response;
            }
            catch (Exception e) {
                throw new XFormsException(e);
            }
        }
        if (submission.getMethod().equalsIgnoreCase("put")) {
            if (!submission.getReplace().equals("none")) {
                throw new XFormsException("submission mode '" + submission.getReplace() + "' not supported");
            }
            try {
                URI uri = new URI(this.getURI());
                String fileName = uri.getSchemeSpecificPart();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("putting file '" + fileName + "'"));
                }
                FileOutputStream stream = new FileOutputStream(new File(fileName));
                this.serialize(submission, instance, stream);
                stream.close();
            }
            catch (Exception e) {
                throw new XFormsException(e);
            }
            return new HashMap();
        }
        throw new XFormsException("submission method '" + submission.getMethod() + "' not supported");
    }
}

