/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.connector.http;

import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.log4j.Logger;
import org.chiba.xml.xforms.connector.http.HTTPSubmissionHandler;
import org.chiba.xml.xforms.core.Submission;
import org.chiba.xml.xforms.exception.XFormsException;
import org.w3c.dom.Node;

public class RedirectingHTTPSubmissionHandler
extends HTTPSubmissionHandler {
    private static final Logger LOGGER = Logger.getLogger(RedirectingHTTPSubmissionHandler.class);
    private Submission mySubmission = null;

    public Map submit(Submission submission, Node instance) throws XFormsException {
        this.mySubmission = submission;
        return super.submit(submission, instance);
    }

    protected void execute(HttpMethod httpMethod) throws Exception {
        int idx;
        LOGGER.info((Object)"RedirectingHTTPSubmissionDriver.execute");
        new HttpClient().executeMethod(httpMethod);
        if (httpMethod.getStatusCode() >= 400) {
            throw new XFormsException("HTTP status " + httpMethod.getStatusCode() + ": " + httpMethod.getStatusText());
        }
        String locationURL = null;
        if (httpMethod.getStatusCode() == 201) {
            Header locationURLHdr = httpMethod.getResponseHeader("Location");
            if (null == locationURLHdr) {
                locationURLHdr = httpMethod.getResponseHeader("location");
            }
            if (null == locationURLHdr) {
                locationURLHdr = httpMethod.getResponseHeader("Content-Location");
            }
            if (null == locationURLHdr) {
                locationURLHdr = httpMethod.getResponseHeader("content-location");
            }
            if (null != locationURLHdr) {
                locationURL = locationURLHdr.getValue();
            }
        } else if (httpMethod.getStatusCode() == 204 && (idx = (locationURL = httpMethod.getURI().toString()).lastIndexOf(47)) > -1) {
            locationURL = locationURL.substring(0, idx + 1);
        }
        if (null != locationURL) {
            LOGGER.info((Object)("Redirecting to location: " + locationURL));
            this.mySubmission.redirect(locationURL);
        }
        this.handleHttpMethod(httpMethod);
    }
}

