/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.constraints;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.apache.log4j.Logger;
import org.apache.xerces.dom.NodeImpl;
import org.chiba.xml.xforms.constraints.CalculateVertex;
import org.chiba.xml.xforms.constraints.ConstraintVertex;
import org.chiba.xml.xforms.constraints.ReadonlyVertex;
import org.chiba.xml.xforms.constraints.RelevantVertex;
import org.chiba.xml.xforms.constraints.RequiredVertex;
import org.chiba.xml.xforms.constraints.Vertex;
import org.chiba.xml.xforms.core.Instance;
import org.chiba.xml.xforms.core.ModelItem;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xpath.XPathUtil;

public class DependencyGraph {
    protected static Logger LOGGER = Logger.getLogger(DependencyGraph.class);
    protected Vector vertices = new Vector();

    public Vertex getVertex(NodeImpl instanceNode, short property) {
        Enumeration enumeration = this.vertices.elements();
        while (enumeration.hasMoreElements()) {
            boolean equalTypes;
            Vertex v = (Vertex)enumeration.nextElement();
            boolean equalNodes = v.instanceNode == instanceNode;
            boolean bl = equalTypes = v.getVertexType() == property;
            if (!equalNodes || !equalTypes) continue;
            return v;
        }
        return null;
    }

    public Vector getXPathRefNodes(JXPathContext relativeContext, String xpath, Set references) throws XFormsException {
        Vector<Object> refNodes = new Vector<Object>();
        Iterator pathes = references.iterator();
        while (pathes.hasNext()) {
            String refPath = pathes.next().toString();
            Instance instance = (Instance)relativeContext.getParentContext().getContextBean();
            JXPathContext context = relativeContext;
            if (XPathUtil.hasInstanceFunction(refPath)) {
                String instanceId = instance.getModel().computeInstanceId(refPath);
                instance = (Instance)instance.getModel().getContainer().lookup(instanceId);
                context = instance.getInstanceContext();
            }
            Iterator iterator = context.iteratePointers(refPath);
            while (iterator.hasNext()) {
                Pointer localPointer = (Pointer)iterator.next();
                String realPath = localPointer.asPath();
                ModelItem modelItem = instance.getModelItem(realPath);
                if (modelItem == null) continue;
                refNodes.add(modelItem.getNode());
            }
        }
        return refNodes;
    }

    public void addEdge(Vertex from, Vertex to) {
        from.addDep(to);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("addEdge: from " + from + " to " + to));
        }
    }

    public Vertex addVertex(JXPathContext relativeContext, NodeImpl instanceNode, String xpathExpression, short property) {
        Vertex v = this.getVertex(instanceNode, property);
        if (v != null) {
            String s = v.toString();
            v.wasAlreadyInGraph = true;
            if (v.relativeContext == null) {
                v.relativeContext = relativeContext;
                v.xpathExpression = xpathExpression;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("addVertex: found vertex " + s + ", changed to " + v));
            }
            return v;
        }
        switch (property) {
            case 1: {
                v = new CalculateVertex(relativeContext, instanceNode, xpathExpression);
                break;
            }
            case 2: {
                v = new RelevantVertex(relativeContext, instanceNode, xpathExpression);
                break;
            }
            case 3: {
                v = new ReadonlyVertex(relativeContext, instanceNode, xpathExpression);
                break;
            }
            case 5: {
                v = new ConstraintVertex(relativeContext, instanceNode, xpathExpression);
                break;
            }
            case 4: {
                v = new RequiredVertex(relativeContext, instanceNode, xpathExpression);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("addVertex: built vertex " + v));
        }
        this.vertices.addElement(v);
        return v;
    }

    private void addVertex(Vertex v) {
        if (!this.vertices.contains(v)) {
            this.vertices.addElement(v);
        }
    }

    public void recalculate() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"recalculate: starting ...");
        }
        this.removeNonZeroVertices();
        while (this.vertices.size() > 0) {
            Vertex v = (Vertex)this.vertices.firstElement();
            this.removeVertex(v);
            v.compute();
            Enumeration enumeration = v.depList.elements();
            while (enumeration.hasMoreElements()) {
                Vertex w = (Vertex)enumeration.nextElement();
                --w.inDegree;
                if (w.inDegree != 0) continue;
                this.addVertex(w);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"recalculate: finished");
        }
    }

    private void removeNonZeroVertices() {
        Vertex v;
        Vector<Vertex> nonzeros = new Vector<Vertex>();
        Enumeration enumeration = this.vertices.elements();
        while (enumeration.hasMoreElements()) {
            v = (Vertex)enumeration.nextElement();
            if (v.inDegree <= 0) continue;
            nonzeros.addElement(v);
        }
        enumeration = nonzeros.elements();
        while (enumeration.hasMoreElements()) {
            v = (Vertex)enumeration.nextElement();
            this.removeVertex(v);
        }
    }

    protected void removeVertex(Vertex v) {
        this.vertices.removeElement(v);
    }
}

