/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.constraints;

import org.apache.log4j.Logger;
import org.apache.xerces.dom.NodeImpl;
import org.chiba.xml.dom.DOMUtil;
import org.chiba.xml.ns.NamespaceResolver;
import org.chiba.xml.xforms.core.Instance;
import org.chiba.xml.xforms.core.ModelItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class RelevanceSelector {
    private static Logger LOGGER = Logger.getLogger(RelevanceSelector.class);

    public static Document selectRelevant(Instance instance) {
        return RelevanceSelector.selectRelevant(instance, "/");
    }

    public static Document selectRelevant(Instance instance, String path) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("select relevant: processing " + path));
        }
        Document relevantDocument = DOMUtil.newDocument(true, false);
        NodeImpl instanceRoot = (NodeImpl)instance.getInstanceDocument().getDocumentElement();
        NodeImpl instanceNode = (NodeImpl)instance.getPointer(path).getNode();
        if (instanceNode.getNodeType() == 9 && RelevanceSelector.isEnabled(instanceRoot)) {
            RelevanceSelector.addElement(relevantDocument, instanceRoot);
        }
        if (instanceNode.getNodeType() == 1 && RelevanceSelector.isEnabled(instanceNode)) {
            RelevanceSelector.addElement(relevantDocument, instanceNode);
            NamespaceResolver.applyNamespaces((Element)instanceNode, relevantDocument.getDocumentElement());
        }
        return relevantDocument;
    }

    private static void addElement(Document relevantDocument, NodeImpl instanceNode) {
        Element relevantElement = instanceNode.getNamespaceURI() == null ? relevantDocument.createElement(instanceNode.getNodeName()) : relevantDocument.createElementNS(instanceNode.getNamespaceURI(), instanceNode.getNodeName());
        relevantDocument.appendChild(relevantElement);
        RelevanceSelector.addAttributes(relevantElement, instanceNode);
        RelevanceSelector.addChildren(relevantElement, instanceNode);
    }

    private static void addElement(Element relevantParent, NodeImpl instanceNode) {
        Document relevantDocument = relevantParent.getOwnerDocument();
        Element relevantElement = instanceNode.getNamespaceURI() == null ? relevantDocument.createElement(instanceNode.getNodeName()) : relevantDocument.createElementNS(instanceNode.getNamespaceURI(), instanceNode.getNodeName());
        ((NodeImpl)relevantElement).setUserData(instanceNode.getUserData());
        relevantParent.appendChild(relevantElement);
        RelevanceSelector.addAttributes(relevantElement, instanceNode);
        RelevanceSelector.addChildren(relevantElement, instanceNode);
    }

    private static void addAttributes(Element relevantElement, NodeImpl instanceNode) {
        NamedNodeMap instanceAttributes = instanceNode.getAttributes();
        for (int index = 0; index < instanceAttributes.getLength(); ++index) {
            NodeImpl instanceAttr = (NodeImpl)instanceAttributes.item(index);
            if (!RelevanceSelector.isEnabled(instanceAttr)) continue;
            if (instanceAttr.getNamespaceURI() == null) {
                relevantElement.setAttribute(instanceAttr.getNodeName(), instanceAttr.getNodeValue());
                continue;
            }
            relevantElement.setAttributeNS(instanceAttr.getNamespaceURI(), instanceAttr.getNodeName(), instanceAttr.getNodeValue());
        }
    }

    private static void addChildren(Element relevantElement, NodeImpl instanceNode) {
        Document ownerDocument = relevantElement.getOwnerDocument();
        NodeList instanceChildren = instanceNode.getChildNodes();
        block5: for (int index = 0; index < instanceChildren.getLength(); ++index) {
            NodeImpl instanceChild = (NodeImpl)instanceChildren.item(index);
            if (!RelevanceSelector.isEnabled(instanceChild)) continue;
            switch (instanceChild.getNodeType()) {
                case 3: {
                    relevantElement.appendChild(ownerDocument.createTextNode(instanceChild.getNodeValue()));
                    continue block5;
                }
                case 4: {
                    relevantElement.appendChild(ownerDocument.createCDATASection(instanceChild.getNodeValue()));
                    continue block5;
                }
                case 1: {
                    RelevanceSelector.addElement(relevantElement, instanceChild);
                    continue block5;
                }
            }
        }
    }

    private static boolean isEnabled(NodeImpl nodeImpl) {
        ModelItem item = (ModelItem)nodeImpl.getUserData();
        return item == null || item.isEnabled();
    }
}

