/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.constraints;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.xerces.dom.NodeImpl;

public abstract class Vertex {
    public static final short CALCULATE_VERTEX = 1;
    public static final short RELEVANT_VERTEX = 2;
    public static final short READONLY_VERTEX = 3;
    public static final short REQUIRED_VERTEX = 4;
    public static final short CONSTRAINT_VERTEX = 5;
    protected JXPathContext relativeContext = null;
    protected NodeImpl instanceNode = null;
    protected String xpathExpression = null;
    protected Vector depList;
    protected boolean wasAlreadyInGraph = false;
    protected int inDegree;

    public Vertex(JXPathContext relativeContext, NodeImpl instanceNode, String xpathExpression) {
        this.relativeContext = relativeContext;
        this.instanceNode = instanceNode;
        this.xpathExpression = xpathExpression;
        this.depList = new Vector();
        this.inDegree = 0;
    }

    public abstract short getVertexType();

    public abstract void compute();

    public String getXPathExpression() {
        return this.xpathExpression;
    }

    public void addDep(Vertex to) {
        if (this.depList.contains(to) || this == to) {
            return;
        }
        this.depList.addElement(to);
        ++to.inDegree;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Vertex)) {
            return false;
        }
        Vertex v = (Vertex)object;
        return this.instanceNode.equals(v.instanceNode) && this.xpathExpression.equals(v.xpathExpression) && this.getVertexType() == v.getVertexType();
    }

    public void print(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("\t");
        }
        System.out.println(this.getClass().getName() + ": " + this.instanceNode.getNodeName() + " = '" + this.instanceNode.getTextContent() + "' inDegree:" + this.inDegree);
        Enumeration enumeration = this.depList.elements();
        while (enumeration.hasMoreElements()) {
            Vertex v = (Vertex)enumeration.nextElement();
            v.print(level + 1);
        }
    }
}

