/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.core.impl;

import org.apache.xerces.dom.NodeImpl;
import org.chiba.xml.xforms.core.DeclarationView;
import org.chiba.xml.xforms.core.LocalUpdateView;
import org.chiba.xml.xforms.core.ModelItem;
import org.chiba.xml.xforms.core.StateChangeView;
import org.chiba.xml.xforms.core.impl.DeclarationViewImpl;
import org.chiba.xml.xforms.core.impl.LocalUpdateViewImpl;
import org.chiba.xml.xforms.core.impl.StateChangeViewImpl;

public class XercesNodeImpl
implements ModelItem {
    private String id;
    private NodeImpl node;
    private ModelItem parent;
    private DeclarationViewImpl declarationView;
    private LocalUpdateViewImpl localUpdateView;
    private StateChangeViewImpl stateChangeView;
    private String filename;
    private String mediatype;

    public XercesNodeImpl(String id) {
        this.id = id;
        this.declarationView = new DeclarationViewImpl();
        this.localUpdateView = new LocalUpdateViewImpl();
        this.stateChangeView = new StateChangeViewImpl(this);
    }

    public String getId() {
        return this.id;
    }

    public Object getNode() {
        return this.node;
    }

    public void setNode(Object node) {
        this.node = (NodeImpl)node;
    }

    public ModelItem getParent() {
        return this.parent;
    }

    public void setParent(ModelItem parent) {
        this.parent = parent;
    }

    public boolean isReadonly() {
        if (this.parent != null) {
            return this.localUpdateView.isLocalReadonly() || this.parent.isReadonly();
        }
        return this.localUpdateView.isLocalReadonly();
    }

    public boolean isRequired() {
        return this.localUpdateView.isLocalRequired();
    }

    public boolean isEnabled() {
        if (this.parent != null) {
            return this.localUpdateView.isLocalRelevant() && this.parent.isEnabled();
        }
        return this.localUpdateView.isLocalRelevant();
    }

    public boolean isValid() {
        return this.localUpdateView.isConstraintValid() && this.localUpdateView.isDatatypeValid();
    }

    public String getValue() {
        return this.node.getNodeValue();
    }

    public void setValue(String value) {
        if (this.valueChanged(value)) {
            this.node.setNodeValue(value);
        }
    }

    public DeclarationView getDeclarationView() {
        return this.declarationView;
    }

    public LocalUpdateView getLocalUpdateView() {
        return this.localUpdateView;
    }

    public StateChangeView getStateChangeView() {
        return this.stateChangeView;
    }

    public boolean isXSINillable() {
        return false;
    }

    public String getXSIType() {
        return null;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setMediatype(String mediatype) {
        this.mediatype = mediatype;
    }

    public String getMediatype() {
        return this.mediatype;
    }

    protected final boolean valueChanged(String value) {
        String current = this.getValue();
        if (current == null && value == null || current != null && current.equals(value)) {
            return false;
        }
        this.stateChangeView.setValueChanged();
        return true;
    }
}

