/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.ui;

import java.util.Iterator;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.log4j.Logger;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.AbstractFormControl;
import org.chiba.xml.xforms.ui.Item;
import org.w3c.dom.Element;

public class Selector
extends AbstractFormControl {
    private static final Logger LOGGER = Logger.getLogger(Selector.class);
    private boolean multiple;
    private JXPathContext context;

    public Selector(Element element, Model model) {
        super(element, model);
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public void setValue(String value) throws XFormsException {
        if (this.isBound()) {
            this.model.getInstance(this.getInstanceId()).setNodeValue(this.getLocationPath(), value);
            this.dispatchSelectionWithoutValueChange(value);
            this.dispatchValueChangeSequence();
        }
    }

    public void init() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " init"));
        }
        this.initializeDefaultAction();
        this.initializeInstanceNode();
        this.initializeElementState();
        this.initializeChildren();
        this.initializeSelection();
        this.initializeActions();
    }

    public void update() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " update"));
        }
        this.updateElementState();
        this.updateChildren();
        this.updateSelection();
    }

    protected void initializeSelection() throws XFormsException {
        if (this.isBound()) {
            this.setSelection(true, false, this.getValue());
        }
    }

    protected void updateSelection() throws XFormsException {
        if (this.isBound()) {
            this.setSelection(false, false, this.getValue());
        }
    }

    protected void dispatchSelectionWithoutValueChange(String value) throws XFormsException {
        if (this.isBound()) {
            this.setSelection(false, true, value);
        }
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    private void setSelection(boolean force, boolean dispatch, String value) throws XFormsException {
        if (this.context == null) {
            this.context = JXPathContext.newContext((Object)this.element);
            this.context.registerNamespace("chiba", "http://chiba.sourceforge.net/xforms");
            this.context.registerNamespace("xf", "http://www.w3.org/2002/xforms");
        }
        boolean selectable = true;
        Iterator iterator = this.context.iterate("//" + this.xformsPrefix + ":" + "item" + "[not(ancestor::" + "chiba" + ":data)]/@id");
        while (iterator.hasNext()) {
            String itemId = iterator.next().toString();
            Item item = (Item)this.container.lookup(itemId);
            if (selectable && this.isInRange(value, item.getValue())) {
                if (force || !item.isSelected()) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug((Object)(this + " selecting item " + itemId));
                    }
                    item.select();
                    if (dispatch) {
                        this.container.dispatch(item.getTarget(), "xforms-select", null);
                    }
                }
                selectable = this.isMultiple();
                continue;
            }
            if (!force && !item.isSelected()) continue;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " deselecting item " + itemId));
            }
            item.deselect();
            if (!dispatch) continue;
            this.container.dispatch(item.getTarget(), "xforms-deselect", null);
        }
    }

    private boolean isInRange(String boundValue, String itemValue) {
        if (boundValue == null || itemValue == null) {
            return false;
        }
        if (boundValue == itemValue) {
            return true;
        }
        if (this.isMultiple()) {
            String item;
            String bound = " " + boundValue + " ";
            return bound.indexOf(item = " " + itemValue + " ") > -1;
        }
        return boundValue.equals(itemValue);
    }
}

