/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.ui;

import org.apache.log4j.Logger;
import org.chiba.xml.xforms.XFormsElement;
import org.chiba.xml.xforms.core.Model;
import org.chiba.xml.xforms.core.Submission;
import org.chiba.xml.xforms.exception.XFormsBindingException;
import org.chiba.xml.xforms.exception.XFormsException;
import org.chiba.xml.xforms.ui.Trigger;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class Submit
extends Trigger
implements EventListener {
    private static final Logger LOGGER = Logger.getLogger(Submit.class);
    private String submissionId = null;

    public Submit(Element element, Model model) {
        super(element, model);
    }

    public void init() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " init"));
        }
        this.initializeDefaultAction();
        this.initializeInstanceNode();
        this.initializeSubmit();
        this.initializeElementState();
        this.initializeChildren();
        this.initializeActions();
    }

    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeDefaultAction();
        this.disposeChildren();
        this.disposeElementState();
        this.disposeSubmit();
        this.disposeSelf();
    }

    public void setValue(String value) throws XFormsException {
        this.getLogger().warn((Object)(this + " set value: the value of a submit control cannot be set"));
    }

    public void handleEvent(Event event) {
        try {
            if (event.getType().equals("DOMActivate")) {
                this.container.dispatch(this.submissionId, "xforms-submit", null);
                return;
            }
        }
        catch (Exception e) {
            this.container.handleEventException(e);
            event.preventDefault();
            event.stopPropagation();
        }
    }

    protected final void initializeSubmit() throws XFormsException {
        this.submissionId = this.getXFormsAttribute("submission");
        if (this.submissionId == null) {
            throw new XFormsBindingException("missing submission attribute at " + this, this.target, null);
        }
        XFormsElement submission = this.container.lookup(this.submissionId);
        if (submission == null || !(submission instanceof Submission)) {
            throw new XFormsBindingException("invalid submission id at " + this, this.target, (Object)this.submissionId);
        }
        this.target.addEventListener("DOMActivate", this, false);
    }

    protected final void disposeSubmit() {
        this.submissionId = null;
        this.target.removeEventListener("DOMActivate", this, false);
    }

    protected Logger getLogger() {
        return LOGGER;
    }
}

