/*
 * Decompiled with CFR 0.152.
 */
package org.chiba.xml.xforms.xpath;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.jxpath.ExpressionContext;
import org.apache.commons.jxpath.JXPathContext;
import org.chiba.xml.xforms.Container;
import org.chiba.xml.xforms.XFormsElement;

public class ExtensionFunctionsHelper {
    public static Container getChibaContainer(ExpressionContext expressionContext) {
        if (expressionContext == null) {
            return null;
        }
        for (JXPathContext rootContext = expressionContext.getJXPathContext(); rootContext != null; rootContext = rootContext.getParentContext()) {
            Object rootNode = rootContext.getContextBean();
            if (!(rootNode instanceof XFormsElement)) continue;
            return ((XFormsElement)rootNode).getModel().getContainer();
        }
        return null;
    }

    public static String formatISODate(Date date) {
        TimeZone timeZone = TimeZone.getDefault();
        boolean utc = TimeZone.getTimeZone("UTC").equals(timeZone) || TimeZone.getTimeZone("GMT").equals(timeZone);
        String pattern = utc ? "yyyy-MM-dd'T'HH:mm:ss'Z'" : "yyyy-MM-dd'T'HH:mm:ssZ";
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setTimeZone(timeZone);
        StringBuffer buffer = new StringBuffer(format.format(date));
        if (!utc) {
            buffer.insert(buffer.length() - 2, ':');
        }
        return buffer.toString();
    }

    public static Date parseISODate(String date) throws ParseException {
        String pattern;
        StringBuffer buffer = new StringBuffer(date);
        switch (buffer.length()) {
            case 4: {
                pattern = "yyyy";
                break;
            }
            case 7: {
                pattern = "yyyy-MM";
                break;
            }
            case 10: {
                pattern = "yyyy-MM-dd";
                break;
            }
            default: {
                pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
                if (buffer.length() == 16) {
                    buffer.append(":00");
                }
                if (buffer.length() > 16 && buffer.charAt(16) != ':') {
                    buffer.insert(16, ":00");
                }
                if (buffer.length() == 19) {
                    buffer.append(".000");
                }
                if (buffer.length() > 19 && buffer.charAt(19) != '.') {
                    buffer.insert(19, ".000");
                }
                if (buffer.length() == 23) {
                    buffer.append("+0000");
                }
                if (buffer.length() == 24 && buffer.charAt(23) == 'Z') {
                    buffer.replace(23, 24, "+0000");
                }
                if (buffer.length() != 29 || buffer.charAt(26) != ':') break;
                buffer.deleteCharAt(26);
            }
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format.parse(buffer.toString());
    }

    public static float[] parseISODuration(String duration) throws ParseException {
        float[] values = new float[7];
        int index = 0;
        if (duration.charAt(index) == '-') {
            values[0] = -1.0f;
            ++index;
        } else {
            values[0] = 1.0f;
        }
        if (duration.charAt(index) == 'P') {
            ++index;
        } else {
            throw new ParseException("missing 'P' designator at [" + index + "]", index);
        }
        boolean time = false;
        boolean pending = false;
        String value = null;
        while (index < duration.length()) {
            char designator = duration.charAt(index);
            if (designator == 'T') {
                time = true;
                ++index;
                continue;
            }
            if (ExtensionFunctionsHelper.isDesignator(designator)) {
                if (!pending) {
                    throw new ParseException("missing value at [" + index + "]", index);
                }
                int slot = ExtensionFunctionsHelper.getDesignatorSlot(designator, time);
                try {
                    values[slot] = ExtensionFunctionsHelper.getDesignatorValue(designator, value);
                }
                catch (NumberFormatException e) {
                    throw new ParseException("malformed value at [" + (index - value.length()) + "]", index - value.length());
                }
                pending = false;
                ++index;
                continue;
            }
            int offset = ExtensionFunctionsHelper.getNumberOffset(duration, index);
            if (offset == index) {
                throw new ParseException("missing value at [" + index + "]", index);
            }
            if (offset == duration.length()) {
                throw new ParseException("missing designator at [" + offset + "]", offset);
            }
            value = duration.substring(index, offset);
            index = offset;
            pending = true;
        }
        return values;
    }

    private static int getNumberOffset(String string, int offset) {
        char current;
        int index;
        for (index = offset; index < string.length() && (Character.isDigit(current = string.charAt(index)) || current == '.'); ++index) {
        }
        return index;
    }

    private static boolean isDesignator(char c) {
        return c == 'Y' || c == 'M' || c == 'D' || c == 'H' || c == 'S';
    }

    private static int getDesignatorSlot(char designator, boolean time) {
        switch (designator) {
            case 'Y': {
                return 1;
            }
            case 'M': {
                return time ? 5 : 2;
            }
            case 'D': {
                return 3;
            }
            case 'H': {
                return 4;
            }
            case 'S': {
                return 6;
            }
        }
        return -1;
    }

    private static float getDesignatorValue(char designator, String value) throws NumberFormatException {
        if (designator != 'S') {
            Integer.parseInt(value);
        }
        return Float.parseFloat(value);
    }
}

