/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.header;

import org.alfresco.web.config.forms.DependenciesConfigElement;
import org.alfresco.web.config.forms.DependenciesElementReader;
import org.alfresco.web.config.header.HeaderConfigElement;
import org.alfresco.web.config.header.HeaderItemsConfigElement;
import org.alfresco.web.config.header.HeaderItemsElementReader;
import org.dom4j.Element;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.xml.elementreader.ConfigElementReader;

public class HeaderElementReader
implements ConfigElementReader {
    public static final String ELEMENT_HEADER = "header";

    public ConfigElement parse(Element headerElement) {
        HeaderConfigElement result = null;
        if (headerElement == null) {
            return null;
        }
        String name = headerElement.getName();
        if (!name.equals(ELEMENT_HEADER)) {
            throw new ConfigException(this.getClass().getName() + " can only parse " + ELEMENT_HEADER + " elements, the element passed was '" + name + "'");
        }
        result = new HeaderConfigElement();
        for (Object obj : headerElement.selectNodes("./app-items")) {
            Element appItemsElement = (Element)obj;
            HeaderItemsElementReader appsReader = new HeaderItemsElementReader();
            HeaderItemsConfigElement appsCE = (HeaderItemsConfigElement)appsReader.parse(appItemsElement);
            result.setAppItems(appsCE);
        }
        for (Object obj : headerElement.selectNodes("./user-items")) {
            Element userItemsElement = (Element)obj;
            HeaderItemsElementReader userReader = new HeaderItemsElementReader();
            HeaderItemsConfigElement userCE = (HeaderItemsConfigElement)userReader.parse(userItemsElement);
            result.setUserItems(userCE);
        }
        for (Object obj : headerElement.selectNodes("./dependencies")) {
            Element depsElement = (Element)obj;
            DependenciesElementReader depsReader = new DependenciesElementReader();
            DependenciesConfigElement depsCE = (DependenciesConfigElement)depsReader.parse(depsElement);
            result.setDependencies(depsCE);
        }
        return result;
    }
}

