/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.site.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.RealmCallback;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.jlan.server.auth.kerberos.KerberosDetails;
import org.alfresco.jlan.server.auth.ntlm.NTLM;
import org.alfresco.jlan.server.auth.ntlm.NTLMLogonDetails;
import org.alfresco.jlan.server.auth.ntlm.NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.Type1NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.Type2NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.Type3NTLMMessage;
import org.alfresco.jlan.server.auth.spnego.NegTokenInit;
import org.alfresco.jlan.server.auth.spnego.NegTokenTarg;
import org.alfresco.jlan.server.auth.spnego.OID;
import org.alfresco.jlan.server.auth.spnego.SPNEGO;
import org.alfresco.util.Pair;
import org.alfresco.util.log.NDC;
import org.alfresco.web.site.servlet.KerberosSessionSetupPrivilegedAction;
import org.alfresco.web.site.servlet.config.KerberosConfigElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.RequestContextUtil;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;
import org.springframework.extensions.surf.exception.RequestContextException;
import org.springframework.extensions.surf.site.AuthenticationUtil;
import org.springframework.extensions.surf.types.Page;
import org.springframework.extensions.surf.util.Base64;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorContext;
import org.springframework.extensions.webscripts.connector.ConnectorService;
import org.springframework.extensions.webscripts.connector.Response;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSOAuthenticationFilter
implements Filter,
CallbackHandler {
    private static Log logger = LogFactory.getLog(SSOAuthenticationFilter.class);
    private static final String AUTH_NTLM = "NTLM";
    private static final String AUTH_SPNEGO = "Negotiate";
    private static final String HEADER_WWWAUTHENTICATE = "WWW-Authenticate";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String NTLM_AUTH_DETAILS = "_alfwfNTLMDetails";
    private static final String LOGIN_PAGE_PASSTHROUGH = "_alfwfLoginPassthrough";
    private ConnectorService connectorService;
    private String endpoint;
    private ServletContext servletContext;
    private String krbAccountName;
    private String krbPassword;
    private String krbRealm;
    private String krbEndpointSPN;
    private String jaasLoginEntryName;
    private LoginContext jaasLoginContext;

    public void init(FilterConfig args) throws ServletException {
        this.servletContext = args.getServletContext();
        ApplicationContext context = this.getApplicationContext();
        this.connectorService = (ConnectorService)context.getBean("connector.service");
        ConfigService configService = (ConfigService)context.getBean("web.config");
        RemoteConfigElement remoteConfig = (RemoteConfigElement)configService.getConfig((Object)"Remote").getConfigElement("remote");
        if (remoteConfig == null) {
            return;
        }
        String endpoint = args.getInitParameter("endpoint");
        if (endpoint == null) {
            return;
        }
        RemoteConfigElement.EndpointDescriptor endpointDescriptor = remoteConfig.getEndpointDescriptor(endpoint);
        if (endpointDescriptor == null || !endpointDescriptor.getExternalAuth()) {
            return;
        }
        this.endpoint = endpoint;
        KerberosConfigElement krbConfig = (KerberosConfigElement)configService.getConfig((Object)"Kerberos").getConfigElement("kerberos");
        if (krbConfig != null) {
            String krbRealm = krbConfig.getRealm();
            if (krbRealm == null || krbRealm.length() <= 0) {
                throw new ServletException("Kerberos realm not specified");
            }
            this.krbRealm = krbRealm;
            String srvPassword = krbConfig.getPassword();
            if (srvPassword == null || srvPassword.length() <= 0) {
                throw new ServletException("HTTP service account password not specified");
            }
            this.krbPassword = srvPassword;
            String krbEndpointSPN = krbConfig.getEndpointSPN();
            if (krbEndpointSPN == null || krbEndpointSPN.length() <= 0) {
                throw new ServletException("endpoint service principal name not specified");
            }
            this.krbEndpointSPN = krbEndpointSPN;
            String loginEntry = krbConfig.getLoginEntryName();
            if (loginEntry != null) {
                if (loginEntry.length() > 0) {
                    this.jaasLoginEntryName = loginEntry;
                } else {
                    throw new ServletException("Invalid login entry specified");
                }
            }
            try {
                this.jaasLoginContext = new LoginContext(this.jaasLoginEntryName, this);
                this.jaasLoginContext.login();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"HTTP Kerberos login successful");
                }
            }
            catch (LoginException ex) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"HTTP Kerberos web filter error", (Throwable)ex);
                }
                throw new ServletException("Failed to login HTTP server service");
            }
            Subject subj = this.jaasLoginContext.getSubject();
            Principal princ = subj.getPrincipals().iterator().next();
            this.krbAccountName = princ.getName();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Logged on using principal " + this.krbAccountName));
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"NTLMAuthenticationFilter initialised.");
        }
    }

    public void doFilter(ServletRequest sreq, ServletResponse sresp, FilterChain chain) throws IOException, ServletException {
        block34: {
            NDC.remove();
            NDC.push((String)Thread.currentThread().getName());
            boolean debug = logger.isDebugEnabled();
            if (this.endpoint == null) {
                chain.doFilter(sreq, sresp);
                return;
            }
            HttpServletRequest req = (HttpServletRequest)sreq;
            HttpServletResponse res = (HttpServletResponse)sresp;
            HttpSession session = req.getSession();
            if (debug) {
                logger.debug((Object)("Processing request " + req.getRequestURI() + " SID:" + session.getId()));
            }
            RequestContext context = null;
            try {
                context = RequestContextUtil.initRequestContext((ApplicationContext)this.getApplicationContext(), (HttpServletRequest)((HttpServletRequest)sreq), (boolean)true);
            }
            catch (RequestContextException ex) {
                throw new ServletException((Throwable)ex);
            }
            String authHdr = req.getHeader(HEADER_AUTHORIZATION);
            if (authHdr == null && AuthenticationUtil.isAuthenticated((HttpServletRequest)req)) {
                this.challengeOrPassThrough(chain, req, res, session);
                return;
            }
            Page page = context.getPage();
            if (page != null && page.getAuthentication() == Description.RequiredAuthentication.none) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Unauthenticated page requested - skipping auth filter...");
                }
                chain.doFilter(sreq, sresp);
                return;
            }
            if ("login".equals(req.getParameter("pt")) && req.getRequestURI().endsWith("/page")) {
                this.redirectToLoginPage(req, res);
                return;
            }
            if (session.getAttribute(LOGIN_PAGE_PASSTHROUGH) != null) {
                if (debug) {
                    logger.debug((Object)"Login page requested, chaining ...");
                }
                chain.doFilter(sreq, sresp);
                return;
            }
            String userAgent = req.getHeader("user-agent");
            if (userAgent != null && userAgent.indexOf("Opera ") != -1) {
                if (debug) {
                    logger.debug((Object)"Opera detected, redirecting to login page");
                }
                this.redirectToLoginPage(req, res);
                return;
            }
            if (authHdr == null) {
                if (debug) {
                    logger.debug((Object)("New auth request from " + req.getRemoteHost() + " (" + req.getRemoteAddr() + ":" + req.getRemotePort() + ")"));
                }
                this.challengeOrPassThrough(chain, req, res, session);
                return;
            }
            if (authHdr.startsWith(AUTH_SPNEGO) && this.krbRealm != null) {
                byte[] spnegoByts = Base64.decode((byte[])authHdr.substring(10).getBytes());
                if (this.isNTLMSSPBlob(spnegoByts, 0)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Client sent an NTLMSSP security blob");
                    }
                    this.restartAuthProcess(session, req, res, AUTH_SPNEGO);
                    return;
                }
                int tokType = -1;
                try {
                    tokType = SPNEGO.checkTokenType((byte[])spnegoByts, (int)0, (int)spnegoByts.length);
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (tokType == 0) {
                    NegTokenInit negToken = new NegTokenInit();
                    try {
                        negToken.decode(spnegoByts, 0, spnegoByts.length);
                        String oidStr = null;
                        if (negToken.numberOfOids() > 0) {
                            oidStr = negToken.getOidAt(0).toString();
                        }
                        if (oidStr == null || !oidStr.equals("1.2.840.48018.1.2.2") && !oidStr.equals("1.2.840.113554.1.2.2")) break block34;
                        if (this.doKerberosLogon(negToken, req, res, session) != null) {
                            chain.doFilter((ServletRequest)req, (ServletResponse)res);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"Request processing ended");
                            }
                            break block34;
                        }
                        this.restartAuthProcess(session, req, res, AUTH_SPNEGO);
                    }
                    catch (IOException ex) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)ex);
                        }
                        break block34;
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Unknown SPNEGO token type");
                }
                this.restartAuthProcess(session, req, res, AUTH_SPNEGO);
            } else if (authHdr.startsWith(AUTH_NTLM)) {
                byte[] authHdrByts = authHdr.substring(5).getBytes();
                byte[] ntlmByts = Base64.decode((byte[])authHdrByts);
                int ntlmTyp = NTLMMessage.isNTLMType((byte[])ntlmByts);
                if (ntlmTyp == 1) {
                    Type1NTLMMessage type1Msg = new Type1NTLMMessage(ntlmByts);
                    session.invalidate();
                    session = req.getSession();
                    this.processType1(type1Msg, req, res, session);
                } else if (ntlmTyp == 3) {
                    Type3NTLMMessage type3Msg = new Type3NTLMMessage(ntlmByts);
                    this.processType3(type3Msg, req, res, session, chain);
                } else {
                    if (debug) {
                        logger.debug((Object)"NTLM not handled, redirecting to login page");
                    }
                    this.redirectToLoginPage(req, res);
                }
            }
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            Callback cb;
            if (callbacks[i] instanceof NameCallback) {
                cb = (NameCallback)callbacks[i];
                ((NameCallback)cb).setName(this.krbAccountName);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                cb = (PasswordCallback)callbacks[i];
                ((PasswordCallback)cb).setPassword(this.krbPassword.toCharArray());
                continue;
            }
            if (callbacks[i] instanceof RealmCallback) {
                cb = (RealmCallback)callbacks[i];
                ((TextInputCallback)cb).setText(this.krbRealm);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }

    private void challengeOrPassThrough(FilterChain chain, HttpServletRequest req, HttpServletResponse res, HttpSession session) throws IOException, ServletException {
        try {
            Connector conn = this.connectorService.getConnector(this.endpoint, AuthenticationUtil.getUserId((HttpServletRequest)req), session);
            ConnectorContext ctx = new ConnectorContext();
            Response remoteRes = conn.call("/touch", ctx);
            if (401 == remoteRes.getStatus().getCode()) {
                String authHdr;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Repository session timed out - restarting auth process...");
                }
                if ((authHdr = (String)remoteRes.getStatus().getHeaders().get(HEADER_WWWAUTHENTICATE)) != null) {
                    this.restartAuthProcess(session, req, res, authHdr);
                } else {
                    session.invalidate();
                    this.redirectToLoginPage(req, res);
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Authentication not required, chaining ...");
            }
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        catch (ConnectorServiceException cse) {
            throw new PlatformRuntimeException("Incorrectly configured endpoint ID: " + this.endpoint);
        }
    }

    public void destroy() {
    }

    private Map<String, String> getConnectionHeaders(Connector conn) {
        HashMap<String, String> headers = null;
        if (conn.getConnectorSession().getCookie("JSESSIONID") == null) {
            headers = new HashMap<String, String>(1);
            headers.put("Cookie", "");
        }
        return headers;
    }

    private void restartAuthProcess(HttpSession session, HttpServletRequest req, HttpServletResponse res, String authHdr) throws IOException {
        session.invalidate();
        res.setHeader(HEADER_WWWAUTHENTICATE, authHdr);
        res.setStatus(401);
        PrintWriter out = res.getWriter();
        out.println("<html><head>");
        out.println("<meta http-equiv=\"Refresh\" content=\"0; url=" + req.getContextPath() + "/page?pt=login" + "\">");
        out.println("</head><body><p>Please <a href=\"" + req.getContextPath() + "/page?pt=login" + "\">log in</a>.</p>");
        out.println("</body></html>");
        out.close();
        res.flushBuffer();
    }

    private void processType1(Type1NTLMMessage type1Msg, HttpServletRequest req, HttpServletResponse res, HttpSession session) throws IOException {
        NTLMLogonDetails ntlmDetails;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Received type1 " + type1Msg));
        }
        if ((ntlmDetails = (NTLMLogonDetails)session.getAttribute(NTLM_AUTH_DETAILS)) != null && ntlmDetails.hasType2Message() && ntlmDetails.hasNTLMHashedPassword()) {
            Type2NTLMMessage cachedType2 = ntlmDetails.getType2Message();
            byte[] type2Bytes = cachedType2.getBytes();
            String ntlmBlob = "NTLM " + new String(Base64.encodeBytes((byte[])type2Bytes, (int)8));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sending cached NTLM type2 to client - " + cachedType2));
            }
            res.setHeader(HEADER_WWWAUTHENTICATE, ntlmBlob);
            res.setStatus(401);
            res.flushBuffer();
        } else {
            session.removeAttribute(NTLM_AUTH_DETAILS);
            try {
                Connector conn = this.connectorService.getConnector(this.endpoint, session);
                ConnectorContext ctx = new ConnectorContext(null, this.getConnectionHeaders(conn));
                Response remoteRes = conn.call("/touch", ctx, req, null);
                if (401 == remoteRes.getStatus().getCode()) {
                    String authHdr = (String)remoteRes.getStatus().getHeaders().get(HEADER_WWWAUTHENTICATE);
                    if (authHdr.startsWith(AUTH_NTLM) && authHdr.length() > 4) {
                        byte[] authHdrByts = authHdr.substring(5).getBytes();
                        byte[] ntlmByts = Base64.decode((byte[])authHdrByts);
                        int ntlmType = NTLMMessage.isNTLMType((byte[])ntlmByts);
                        if (ntlmType == 2) {
                            Type2NTLMMessage type2Msg = new Type2NTLMMessage(ntlmByts);
                            ntlmDetails = new NTLMLogonDetails();
                            ntlmDetails.setType2Message(type2Msg);
                            session.setAttribute(NTLM_AUTH_DETAILS, (Object)ntlmDetails);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Sending NTLM type2 to client - " + type2Msg));
                            }
                            byte[] type2Bytes = type2Msg.getBytes();
                            String ntlmBlob = "NTLM " + new String(Base64.encodeBytes((byte[])type2Bytes, (int)8));
                            res.setHeader(HEADER_WWWAUTHENTICATE, ntlmBlob);
                            res.setStatus(401);
                            res.flushBuffer();
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Unexpected NTLM message type from repository: NTLMType" + ntlmType));
                            }
                            this.redirectToLoginPage(req, res);
                        }
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Unexpected response from repository: WWW-Authenticate:" + authHdr));
                        }
                        this.redirectToLoginPage(req, res);
                    }
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Unexpected response from repository: " + remoteRes.getStatus().getMessage()));
                    }
                    this.redirectToLoginPage(req, res);
                }
            }
            catch (ConnectorServiceException cse) {
                throw new PlatformRuntimeException("Incorrectly configured endpoint ID: " + this.endpoint);
            }
        }
    }

    private void processType3(Type3NTLMMessage type3Msg, HttpServletRequest req, HttpServletResponse res, HttpSession session, FilterChain chain) throws IOException, ServletException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Received type3 " + type3Msg));
        }
        NTLMLogonDetails ntlmDetails = (NTLMLogonDetails)session.getAttribute(NTLM_AUTH_DETAILS);
        String userId = AuthenticationUtil.getUserId((HttpServletRequest)req);
        String userName = type3Msg.getUserName();
        String workstation = type3Msg.getWorkstation();
        String domain = type3Msg.getDomain();
        boolean authenticated = false;
        if (userId != null && ntlmDetails != null && ntlmDetails.hasNTLMHashedPassword()) {
            byte[] ntlmPwd = type3Msg.getNTLMHash();
            byte[] cachedPwd = ntlmDetails.getNTLMHashedPassword();
            if (ntlmPwd != null && ntlmPwd.length == cachedPwd.length) {
                authenticated = true;
                for (int i = 0; i < ntlmPwd.length; ++i) {
                    if (ntlmPwd[i] == cachedPwd[i]) continue;
                    authenticated = false;
                    break;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using cached NTLM hash, authenticated = " + authenticated));
            }
            if (!authenticated) {
                this.restartAuthProcess(session, req, res, AUTH_NTLM);
            } else {
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
            }
        } else {
            try {
                Connector conn = this.connectorService.getConnector(this.endpoint, session);
                ConnectorContext ctx = new ConnectorContext(null, this.getConnectionHeaders(conn));
                Response remoteRes = conn.call("/touch", ctx, req, null);
                if (401 == remoteRes.getStatus().getCode()) {
                    String authHdr = (String)remoteRes.getStatus().getHeaders().get(HEADER_WWWAUTHENTICATE);
                    if (authHdr.equals(AUTH_NTLM)) {
                        res.setHeader(HEADER_WWWAUTHENTICATE, AUTH_NTLM);
                        res.setStatus(401);
                        res.flushBuffer();
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Unexpected response from repository: WWW-Authenticate:" + authHdr));
                        }
                        this.redirectToLoginPage(req, res);
                    }
                } else if (200 == remoteRes.getStatus().getCode() || 307 == remoteRes.getStatus().getCode()) {
                    if (ntlmDetails == null) {
                        ntlmDetails = new NTLMLogonDetails(userName, workstation, domain, false, null);
                        ntlmDetails.setNTLMHashedPassword(type3Msg.getNTLMHash());
                        session.setAttribute(NTLM_AUTH_DETAILS, (Object)ntlmDetails);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"No cached NTLM details, created");
                        }
                    } else {
                        ntlmDetails.setDetails(userName, workstation, domain, false, null);
                        ntlmDetails.setNTLMHashedPassword(type3Msg.getNTLMHash());
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Updated cached NTLM details");
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("User logged on via NTLM, " + ntlmDetails));
                    }
                    session.setAttribute("_alf_USER_ID", (Object)userName);
                    session.setAttribute("_alfExternalAuth", (Object)Boolean.TRUE);
                    chain.doFilter((ServletRequest)req, (ServletResponse)res);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Unexpected response from repository: " + remoteRes.getStatus().getMessage()));
                    }
                    this.redirectToLoginPage(req, res);
                }
            }
            catch (ConnectorServiceException cse) {
                throw new PlatformRuntimeException("Incorrectly configured endpoint: " + this.endpoint);
            }
        }
    }

    private void redirectToLoginPage(HttpServletRequest req, HttpServletResponse res) throws IOException {
        req.getSession().setAttribute(LOGIN_PAGE_PASSTHROUGH, (Object)Boolean.TRUE);
        res.sendRedirect(req.getContextPath());
    }

    private ApplicationContext getApplicationContext() {
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.servletContext);
    }

    private boolean isNTLMSSPBlob(byte[] byts, int offset) {
        boolean isNTLMSSP = false;
        if (byts.length - offset >= NTLM.Signature.length) {
            int idx;
            for (idx = 0; idx < NTLM.Signature.length && byts[offset + idx] == NTLM.Signature[idx]; ++idx) {
            }
            if (idx == NTLM.Signature.length) {
                isNTLMSSP = true;
            }
        }
        return isNTLMSSP;
    }

    private NegTokenTarg doKerberosLogon(NegTokenInit negToken, HttpServletRequest req, HttpServletResponse resp, HttpSession httpSess) {
        NegTokenTarg negTokenTarg;
        block8: {
            KerberosDetails krbDetails = null;
            negTokenTarg = null;
            try {
                KerberosSessionSetupPrivilegedAction sessSetupAction = new KerberosSessionSetupPrivilegedAction(this.krbAccountName, negToken.getMechtoken(), this.krbEndpointSPN);
                Pair<KerberosDetails, String> result = Subject.doAs(this.jaasLoginContext.getSubject(), sessSetupAction);
                if (result != null) {
                    Pair<KerberosDetails, String> resultPair = result;
                    krbDetails = (KerberosDetails)resultPair.getFirst();
                    String tokenForEndpoint = (String)resultPair.getSecond();
                    negTokenTarg = new NegTokenTarg(0, OID.KERBEROS5, krbDetails.getResponseToken());
                    if (negTokenTarg != null) {
                        boolean authenticated;
                        String userName = krbDetails.getUserName();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("User " + userName + " logged on via Kerberos; attempting to log on to Alfresco then"));
                        }
                        if (!(authenticated = this.doKerberosDelegateLogin(req, resp, httpSess, userName, tokenForEndpoint))) {
                            return null;
                        }
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)"No SPNEGO response, Kerberos logon failed");
                }
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block8;
                logger.debug((Object)"Kerberos logon error", (Throwable)ex);
            }
        }
        return negTokenTarg;
    }

    private boolean doKerberosDelegateLogin(HttpServletRequest req, HttpServletResponse res, HttpSession session, String userName, String tokenForEndpoint) throws IOException {
        block10: {
            try {
                Connector conn = this.connectorService.getConnector(this.endpoint, session);
                ConnectorContext ctx = new ConnectorContext();
                Response remoteRes = conn.call("/touch", ctx);
                if (401 == remoteRes.getStatus().getCode()) {
                    String authHdr = (String)remoteRes.getStatus().getHeaders().get(HEADER_WWWAUTHENTICATE);
                    if (authHdr.equals(AUTH_SPNEGO)) {
                        ctx = new ConnectorContext(null, Collections.singletonMap(HEADER_AUTHORIZATION, "Negotiate " + tokenForEndpoint));
                        remoteRes = conn.call("/touch", ctx);
                        if (200 == remoteRes.getStatus().getCode() || 307 == remoteRes.getStatus().getCode()) {
                            session.setAttribute("_alf_USER_ID", (Object)userName);
                            session.setAttribute("_alfExternalAuth", (Object)Boolean.TRUE);
                        } else if (401 == remoteRes.getStatus().getCode()) {
                            res.setHeader(HEADER_WWWAUTHENTICATE, authHdr);
                            res.setStatus(401);
                            res.flushBuffer();
                        }
                        break block10;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Unexpected response from repository: WWW-Authenticate:" + authHdr));
                    }
                    return false;
                }
                if (200 == remoteRes.getStatus().getCode() || 307 == remoteRes.getStatus().getCode()) {
                    session.setAttribute("_alf_USER_ID", (Object)userName);
                    session.setAttribute("_alfExternalAuth", (Object)Boolean.TRUE);
                    break block10;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Unexpected response from repository: " + remoteRes.getStatus().getMessage()));
                }
                return false;
            }
            catch (ConnectorServiceException cse) {
                throw new AlfrescoRuntimeException("Incorrectly configured endpoint: " + this.endpoint);
            }
        }
        return true;
    }
}

