/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webservice.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import junit.framework.TestCase;
import org.alfresco.webservice.util.ContentUtils;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public class ContentUtilsTest
extends TestCase {
    private static final String MD5_DIGEST_ALGORITHM = "MD5";
    private static final String TEMPORARY_DESTINATION_PATH = "./destination.tmp";
    private static final String BIG_TEST_FILE = "org/alfresco/webservice/test/resources/big-content.pdf";
    private InputStream inputStream;

    protected void setUp() throws Exception {
        this.inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(BIG_TEST_FILE);
    }

    protected void tearDown() throws Exception {
        this.inputStream.close();
    }

    public void testInputStreamToByteArrayConversion() throws Exception {
        File tempDestination = new File(TEMPORARY_DESTINATION_PATH);
        tempDestination.deleteOnExit();
        FileOutputStream destination = new FileOutputStream(tempDestination);
        MessageDigest digest = MessageDigest.getInstance(MD5_DIGEST_ALGORITHM);
        ContentUtils.copy(new DigestInputStream(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(BIG_TEST_FILE), digest), destination);
        String expectedMD5Sum = new String(Hex.encodeHex((byte[])digest.digest()));
        String actualMD5Sum = DigestUtils.md5Hex((byte[])ContentUtils.convertToByteArray(this.inputStream));
        ContentUtilsTest.assertEquals((String)expectedMD5Sum, (String)actualMD5Sum);
    }
}

