/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webservice.util;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.net.ssl.SSLSocketFactory;
import org.alfresco.webservice.content.Content;
import org.alfresco.webservice.util.AuthenticationUtils;
import org.alfresco.webservice.util.WebServiceException;
import org.alfresco.webservice.util.WebServiceFactory;
import org.springframework.util.FileCopyUtils;

public class ContentUtils {
    public static final int BUFFER_SIZE = 4096;

    public static byte[] convertToByteArray(InputStream inputStream) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileCopyUtils.copy((InputStream)inputStream, (OutputStream)out);
        return out.toByteArray();
    }

    public static String getContentAsString(Content content) {
        String ticket = AuthenticationUtils.getTicket();
        String strUrl = content.getUrl() + "?ticket=" + ticket;
        StringBuilder readContent = new StringBuilder();
        InputStreamReader is = null;
        try {
            URL url = new URL(strUrl);
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("Cookie", "JSESSIONID=" + AuthenticationUtils.getAuthenticationDetails().getSessionId() + ";");
            is = content.getFormat() != null && content.getFormat().getEncoding() != null ? new InputStreamReader(conn.getInputStream(), content.getFormat().getEncoding()) : new InputStreamReader(conn.getInputStream());
            int read = is.read();
            while (read != -1) {
                readContent.append((char)read);
                read = is.read();
            }
        }
        catch (Exception exception) {
            throw new WebServiceException("Unable to get content as string.", exception);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable e) {}
            }
        }
        return readContent.toString();
    }

    public static InputStream getContentAsInputStream(Content content) {
        String ticket = AuthenticationUtils.getTicket();
        String strUrl = content.getUrl() + "?ticket=" + ticket;
        try {
            URL url = new URL(strUrl);
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("Cookie", "JSESSIONID=" + AuthenticationUtils.getAuthenticationDetails().getSessionId() + ";");
            return conn.getInputStream();
        }
        catch (Exception exception) {
            throw new WebServiceException("Unable to get content as inputStream.", exception);
        }
    }

    public static String putContent(File file) {
        return ContentUtils.putContent(file, WebServiceFactory.getHost(), WebServiceFactory.getPort(), null, null);
    }

    public static String putContent(File file, String host, int port) {
        return ContentUtils.putContent(file, host, port, null, null);
    }

    public static String putContent(File file, String host, int port, String mimetype, String encoding) {
        boolean isSSL = WebServiceFactory.getEndpointAddress().toLowerCase().startsWith("https:");
        return ContentUtils.putContent(file, host, port, WebServiceFactory.getEndpointWebapp(), mimetype, encoding, isSSL);
    }

    public static String putContent(File file, String host, int port, String webAppName, String mimetype, String encoding) {
        return ContentUtils.putContent(file, host, port, webAppName, mimetype, encoding, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String putContent(File file, String host, int port, String webAppName, String mimetype, String encoding, boolean isSSL) {
        String result;
        block20: {
            result = null;
            try {
                String url = "/" + webAppName + "/upload/" + URLEncoder.encode(file.getName(), "UTF-8") + "?ticket=" + AuthenticationUtils.getTicket();
                if (mimetype != null) {
                    url = url + "&mimetype=" + mimetype;
                }
                if (encoding != null) {
                    url = url + "&encoding=" + encoding;
                }
                String request = "PUT " + url + " HTTP/1.1\n" + "Cookie: JSESSIONID=" + AuthenticationUtils.getAuthenticationDetails().getSessionId() + ";\n" + "Content-Length: " + file.length() + "\n" + "Host: " + host + ":" + port + "\n" + "Connection: Keep-Alive\n" + "\n";
                Socket socket = null;
                socket = isSSL ? SSLSocketFactory.getDefault().createSocket(host, port) : new Socket(host, port);
                DataOutputStream os = new DataOutputStream(socket.getOutputStream());
                DataInputStream is = new DataInputStream(socket.getInputStream());
                try {
                    String responseLine;
                    if (socket == null || os == null || is == null) break block20;
                    os.writeBytes(request);
                    FileInputStream fileInputStream = new FileInputStream(file);
                    int byteCount = 0;
                    byte[] buffer = new byte[4096];
                    int bytesRead = -1;
                    while ((bytesRead = ((InputStream)fileInputStream).read(buffer)) != -1) {
                        os.write(buffer, 0, bytesRead);
                        byteCount += bytesRead;
                    }
                    os.flush();
                    ((InputStream)fileInputStream).close();
                    boolean firstLine = true;
                    while ((responseLine = is.readLine()) != null) {
                        if (firstLine) {
                            if (responseLine.contains("200")) {
                                firstLine = false;
                                continue;
                            }
                            if (responseLine.contains("401")) {
                                throw new RuntimeException("Content could not be uploaded because invalid credentials have been supplied.");
                            }
                            if (responseLine.contains("403")) {
                                throw new RuntimeException("Content could not be uploaded because user does not have sufficient priveledges.");
                            }
                            throw new RuntimeException("Error returned from upload servlet (" + responseLine + ")");
                        }
                        if (!responseLine.contains("contentUrl")) continue;
                        result = responseLine;
                        break;
                    }
                }
                finally {
                    try {
                        if (os != null) {
                            os.close();
                        }
                        if (is != null) {
                            is.close();
                        }
                        if (socket != null) {
                            socket.close();
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error closing sockets and streams", e);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error writing content to repository server", e);
            }
        }
        return result;
    }

    public static void copyContentToFile(Content content, File file) {
        try {
            FileOutputStream os = new FileOutputStream(file);
            FileCopyUtils.copy((InputStream)ContentUtils.getContentAsInputStream(content), (OutputStream)os);
        }
        catch (IOException exception) {
            throw new WebServiceException("Unable to copy content into file.", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in, OutputStream out) throws IOException {
        try {
            int byteCount = 0;
            byte[] buffer = new byte[4096];
            int bytesRead = -1;
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {}
            try {
                out.close();
            }
            catch (IOException ex) {}
        }
    }
}

