/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import java.util.HashMap;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.runtime.JiBXException;

public class ClassItem {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final byte SIGNATURE_ATTRIBUTE_TAG = 10;
    private static HashMap s_primitiveMap = new HashMap();
    private static HashMap s_typeMap = new HashMap();
    private static HashMap s_signatureParamsMap = new HashMap();
    private static HashMap s_signatureTypeMap = new HashMap();
    private ClassFile m_classFile;
    private String m_name;
    private String m_signature;
    private String m_typeName;
    private String[] m_argTypes;
    private FieldOrMethod m_item;

    public ClassItem(String name, ClassFile cf, FieldOrMethod item) {
        this.m_classFile = cf;
        this.m_name = name;
        this.m_item = item;
        this.m_signature = item.getSignature();
        if (item instanceof Method) {
            this.m_typeName = ClassItem.getTypeFromSignature(this.m_signature);
            this.m_argTypes = ClassItem.getParametersFromSignature(this.m_signature);
        } else {
            this.m_typeName = Utility.signatureToString((String)this.m_signature, (boolean)false);
        }
    }

    public ClassFile getClassFile() {
        return this.m_classFile;
    }

    public String getName() {
        return this.m_name;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public int getArgumentCount() {
        if (this.m_item instanceof Method) {
            return this.m_argTypes.length;
        }
        return 0;
    }

    public String getArgumentType(int index) {
        if (this.m_item instanceof Method) {
            return this.m_argTypes[index];
        }
        throw new IllegalArgumentException("Internal error: not a method");
    }

    public String getParameterName(int index) {
        if (this.m_item instanceof Method) {
            LocalVariableTable vtab;
            int position = index;
            if (!this.isStatic()) {
                ++position;
            }
            if ((vtab = ((Method)this.m_item).getLocalVariableTable()) == null) {
                return null;
            }
            return vtab.getLocalVariable(position).getName();
        }
        throw new IllegalArgumentException("Internal error: not a method");
    }

    public String[] getArgumentTypes() {
        if (this.m_item instanceof Method) {
            return this.m_argTypes;
        }
        return null;
    }

    public int getAccessFlags() {
        return this.m_item.getAccessFlags();
    }

    public void setAccessFlags(int flags) {
        this.m_item.setAccessFlags(flags);
        this.m_classFile.setModified();
    }

    public void makeAccessible(ClassFile src) throws JiBXException {
        int access = this.getAccessFlags();
        if ((access & 1) == 0) {
            ClassFile dest = this.getClassFile();
            if (dest.getPackage().equals(src.getPackage())) {
                if ((access & 2) != 0) {
                    access -= 2;
                }
            } else {
                ClassFile ancestor = src;
                while ((ancestor = ancestor.getSuperFile()) != null && ancestor != dest) {
                }
                if (ancestor == null) {
                    int clear = 6;
                    access = access & ~clear | 1;
                } else if ((access & 4) == 0) {
                    access = access & 0xFFFFFFFD | 4;
                }
            }
            if (access != this.getAccessFlags()) {
                if (dest.isModifiable()) {
                    this.setAccessFlags(access);
                } else {
                    throw new JiBXException("Unable to change access permissions for " + this.getName() + " in class " + src.getName());
                }
            }
        }
    }

    public boolean isStatic() {
        return (this.getAccessFlags() & 8) != 0;
    }

    public String getSignature() {
        return this.m_signature;
    }

    public boolean isMethod() {
        return this.m_item == null || this.m_item instanceof Method;
    }

    public boolean isInitializer() {
        return this.m_item != null && this.m_item.getName().equals("<init>");
    }

    public String[] getExceptions() {
        if (this.m_item instanceof Method) {
            ExceptionTable etab = ((Method)this.m_item).getExceptionTable();
            if (etab != null) {
                return etab.getExceptionNames();
            }
            return EMPTY_STRING_ARRAY;
        }
        return null;
    }

    public String getGenericsSignature() {
        Attribute[] attrs = this.m_item.getAttributes();
        for (int j = 0; j < attrs.length; ++j) {
            Attribute attr = attrs[j];
            if (attr.getTag() != 10) continue;
            return attr.toString();
        }
        return null;
    }

    public static boolean isPrimitive(String type) {
        return s_primitiveMap.get(type) != null;
    }

    public static String getPrimitiveSignature(String type) {
        return ((String[])s_primitiveMap.get(type))[0];
    }

    public static String[] getParametersFromSignature(String sig) {
        String[] types = (String[])s_signatureParamsMap.get(sig);
        if (types == null) {
            types = Utility.methodSignatureArgumentTypes((String)sig, (boolean)false);
            s_signatureParamsMap.put(sig, types);
        }
        return types;
    }

    public static String getTypeFromSignature(String sig) {
        String type = (String)s_signatureTypeMap.get(sig);
        if (type == null) {
            type = Utility.methodSignatureReturnType((String)sig, (boolean)false);
            s_signatureTypeMap.put(sig, type);
        }
        return type;
    }

    public static Type typeFromName(String name) {
        Type type = (Type)s_typeMap.get(name);
        if (type == null) {
            int dimen = 0;
            String base = name;
            while (base.endsWith("[]")) {
                ++dimen;
                base = base.substring(0, base.length() - 2);
            }
            if (dimen > 0) {
                type = (Type)s_typeMap.get(base);
            }
            if (type == null) {
                type = new ObjectType(base);
                s_typeMap.put(base, type);
            }
            if (dimen > 0) {
                type = new ArrayType(type, dimen);
                s_typeMap.put(name, type);
            }
        }
        return type;
    }

    public static ClassItem findVirtualMethod(String name, String[] sigs) throws JiBXException {
        int split = name.lastIndexOf(46);
        String cname = name.substring(0, split);
        String mname = name.substring(split + 1);
        ClassFile cf = ClassCache.getClassFile(cname);
        for (int i = 0; i < sigs.length; ++i) {
            ClassItem method = cf.getMethod(mname, sigs[i]);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public static ClassItem findStaticMethod(String name, String[] sigs) throws JiBXException {
        int split = name.lastIndexOf(46);
        String cname = name.substring(0, split);
        String mname = name.substring(split + 1);
        ClassFile cf = ClassCache.getClassFile(cname);
        for (int i = 0; i < sigs.length; ++i) {
            ClassItem method = cf.getStaticMethod(mname, sigs[i]);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public static String[] getSignatureVariants(String name) throws JiBXException {
        Object obj = s_primitiveMap.get(name);
        if (obj == null) {
            ClassFile cf = ClassCache.getClassFile(name);
            return cf.getInstanceSigs();
        }
        return (String[])obj;
    }

    public static boolean isAssignable(String from, String to) throws JiBXException {
        if (from.equals(to)) {
            return true;
        }
        Object fobj = s_primitiveMap.get(from);
        Object tobj = s_primitiveMap.get(to);
        if (fobj == null && tobj == null) {
            ClassFile cf = ClassCache.getClassFile(from);
            String[] sigs = cf.getInstanceSigs();
            String match = Utility.getSignature((String)to);
            for (int i = 0; i < sigs.length; ++i) {
                if (!match.equals(sigs[i])) continue;
                return true;
            }
            return false;
        }
        if (fobj != null && tobj != null) {
            String[] fsigs = (String[])fobj;
            String[] tsigs = (String[])tobj;
            if (tsigs.length == 1) {
                for (int i = 0; i < fsigs.length; ++i) {
                    if (fsigs[i] != tsigs[0]) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    static {
        s_primitiveMap.put("boolean", new String[]{"Z", "I"});
        s_primitiveMap.put("byte", new String[]{"B", "S", "I"});
        s_primitiveMap.put("char", new String[]{"C", "I"});
        s_primitiveMap.put("double", new String[]{"D"});
        s_primitiveMap.put("float", new String[]{"F"});
        s_primitiveMap.put("int", new String[]{"I"});
        s_primitiveMap.put("long", new String[]{"J"});
        s_primitiveMap.put("short", new String[]{"S", "I"});
        s_primitiveMap.put("void", new String[]{"V"});
        s_typeMap.put("boolean", Type.BOOLEAN);
        s_typeMap.put("byte", Type.BYTE);
        s_typeMap.put("char", Type.CHAR);
        s_typeMap.put("double", Type.DOUBLE);
        s_typeMap.put("float", Type.FLOAT);
        s_typeMap.put("int", Type.INT);
        s_typeMap.put("long", Type.LONG);
        s_typeMap.put("short", Type.SHORT);
        s_typeMap.put("void", Type.VOID);
    }
}

