/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.reference;

import org.alfresco.cmis.CMISRepositoryReference;
import org.alfresco.cmis.CMISServices;
import org.alfresco.repo.cmis.reference.AbstractObjectReference;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;

public class NodePathReference
extends AbstractObjectReference {
    protected String path;
    protected String[] reference;

    public NodePathReference(CMISServices cmisServices, CMISRepositoryReference repo, String path) {
        super(cmisServices, repo);
        this.path = path;
        String[] splitPath = this.path.split("/");
        this.reference = new String[2 + splitPath.length];
        StoreRef storeRef = repo.getStoreRef();
        this.reference[0] = storeRef.getProtocol();
        this.reference[1] = storeRef.getIdentifier();
        System.arraycopy(splitPath, 0, this.reference, 2, splitPath.length);
    }

    public NodeRef getNodeRef() {
        return this.cmisServices.getNode("path", this.reference);
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return "NodePathReference[storeRef=" + this.repo.getStoreRef() + ",path=" + this.path + "]";
    }
}

