/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.rest;

import freemarker.ext.beans.BeanModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.util.List;
import java.util.Map;
import org.alfresco.cmis.CMISFilterNotValidException;
import org.alfresco.cmis.CMISServices;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.repo.web.scripts.RepositoryImageResolver;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.cmr.repository.TemplateValueConverter;
import org.springframework.extensions.webscripts.WebScriptException;

public class CMISRenditionsMethod
implements TemplateMethodModelEx {
    private CMISServices cmisService;
    private TemplateImageResolver imageResolver;
    private TemplateValueConverter templateValueConverter;

    public CMISRenditionsMethod(CMISServices cmisService, RepositoryImageResolver imageResolver, TemplateValueConverter templateValueConverter) {
        this.cmisService = cmisService;
        this.imageResolver = imageResolver.getImageResolver();
        this.templateValueConverter = templateValueConverter;
    }

    public Object exec(List args) throws TemplateModelException {
        NodeRef nodeRef = null;
        String renditionFilter = null;
        try {
            Object wrapped;
            int i = 0;
            Object arg = args.get(i++);
            if (arg instanceof BeanModel && (wrapped = ((BeanModel)arg).getWrappedObject()) != null && wrapped instanceof TemplateNode) {
                nodeRef = ((TemplateNode)wrapped).getNodeRef();
            }
            if ((arg = args.get(i++)) instanceof TemplateScalarModel) {
                renditionFilter = ((TemplateScalarModel)arg).getAsString();
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        if (nodeRef != null) {
            Map renditions;
            try {
                renditions = this.cmisService.getRenditions(nodeRef, renditionFilter);
            }
            catch (CMISFilterNotValidException e) {
                throw new WebScriptException(e.getStatusCode(), e.getMessage(), (Throwable)e);
            }
            return this.templateValueConverter.convertValue((Object)renditions, this.imageResolver);
        }
        return null;
    }
}

