/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.rest.test;

import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.alfresco.repo.cmis.rest.test.BaseCMISTest;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Link;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISObject;
import org.apache.chemistry.abdera.ext.CMISProperty;
import org.junit.Assert;
import org.springframework.extensions.webscripts.TestWebScriptServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectTest
extends BaseCMISTest {
    public void testAspectSet() throws Exception {
        Link children = this.cmisClient.getChildrenLink(this.testCaseFolder);
        Entry document = this.createObject(children.getHref(), this.getName(), "cmis:document");
        TestWebScriptServer.GetRequest documentReq = new TestWebScriptServer.GetRequest(document.getSelfLink().getHref().toString());
        TestWebScriptServer.Response documentRes = this.sendRequest((TestWebScriptServer.Request)documentReq, 200);
        Assert.assertNotNull((Object)documentRes);
        String xml = documentRes.getContentAsString();
        Assert.assertNotNull((Object)xml);
        IRI checkedoutHREF = this.cmisClient.getCheckedOutCollection(this.cmisClient.getWorkspace(this.cmisService));
        TestWebScriptServer.PostRequest checkoutReq = new TestWebScriptServer.PostRequest(checkedoutHREF.toString(), xml, "application/atom+xml;type=entry");
        TestWebScriptServer.Response pwcRes = this.sendRequest((TestWebScriptServer.Request)checkoutReq, 201);
        Assert.assertNotNull((Object)pwcRes);
        Entry pwc = (Entry)this.parse(new StringReader(pwcRes.getContentAsString()));
        Assert.assertNotNull((Object)pwc);
        String updateFile = this.localTemplates.load("AspectTest.addAspects.cmisatomentry.xml");
        TestWebScriptServer.PutRequest updateReq = new TestWebScriptServer.PutRequest(pwc.getEditLink().getHref().toString(), updateFile, "application/atom+xml;type=entry");
        TestWebScriptServer.Response pwcUpdatedres = this.sendRequest((TestWebScriptServer.Request)updateReq, 200);
        Assert.assertNotNull((Object)pwcUpdatedres);
        Entry updated = (Entry)this.parse(new StringReader(pwcUpdatedres.getContentAsString()));
        HashSet<String> appliedAspects = new HashSet<String>(5);
        HashMap<String, String> aspectProperties = new HashMap<String, String>(11);
        this.extractAspectsAndProperties(updated, appliedAspects, aspectProperties);
        this.assertContains(appliedAspects, "P:cm:syndication", "P:cm:summarizable", "P:cm:author");
        AspectTest.assertEquals((String)"Aspect Test (summary)", (String)((String)aspectProperties.get("cm:summary")));
        AspectTest.assertEquals((String)"David Ward", (String)((String)aspectProperties.get("cm:author")));
        String checkinFile = this.localTemplates.load("AspectTest.removeAndAddAspects.cmisatomentry.xml");
        String checkinUrl = pwc.getSelfLink().getHref().toString();
        TestWebScriptServer.Request checkinReq = new TestWebScriptServer.PutRequest(checkinUrl, checkinFile, "application/atom+xml;type=entry").setArgs(Collections.singletonMap("checkin", "true"));
        TestWebScriptServer.Response checkinRes = this.sendRequest(checkinReq, 200);
        Assert.assertNotNull((Object)checkinRes);
        Entry checkedIn = (Entry)this.parse(new StringReader(checkinRes.getContentAsString()));
        HashSet<String> appliedAspects2 = new HashSet<String>(5);
        HashMap<String, String> aspectProperties2 = new HashMap<String, String>(11);
        this.extractAspectsAndProperties(checkedIn, appliedAspects2, aspectProperties2);
        this.assertContains(appliedAspects2, "P:cm:syndication", "P:cm:summarizable", "P:cm:countable");
        this.assertDoesNotContain(appliedAspects2, "P:cm:author");
        AspectTest.assertEquals((String)"Aspect Test (new summary)", (String)((String)aspectProperties2.get("cm:summary")));
        AspectTest.assertNull(aspectProperties2.get("cm:author"));
    }

    private void extractAspectsAndProperties(Entry document, Set<String> appliedAspects, Map<String, String> aspectProperties) {
        CMISObject documentObject = (CMISObject)document.getExtension(CMISConstants.OBJECT);
        Assert.assertNotNull((Object)documentObject);
        Element aspectEl = documentObject.getProperties().getExtension(new QName("http://www.alfresco.org", "aspects"));
        Assert.assertNotNull((Object)aspectEl);
        for (Element child : aspectEl) {
            if (child.getQName().equals(ELEMENT_APPLIED_ASPECTS)) {
                appliedAspects.add(child.getText());
                continue;
            }
            if (child.getQName().equals(ELEMENT_PROPERTIES)) {
                for (Element propertyEl : child) {
                    if (!(propertyEl instanceof CMISProperty)) continue;
                    CMISProperty prop = (CMISProperty)propertyEl;
                    aspectProperties.put(prop.getId(), prop.getStringValue());
                }
                continue;
            }
            AspectTest.fail((String)("Unexpected element: " + child.getQName()));
        }
    }
}

