/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cmis.rest.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.ExtensionFactory;
import org.apache.abdera.model.Base;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.protocol.Response;
import org.apache.abdera.protocol.client.AbderaClient;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.chemistry.abdera.ext.CMISConstants;
import org.apache.chemistry.abdera.ext.CMISExtensionFactory;
import org.apache.chemistry.abdera.ext.CMISObject;
import org.apache.chemistry.abdera.ext.CMISProperties;
import org.apache.chemistry.abdera.ext.CMISProperty;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public class BulkCreateAndQuerySystemTest {
    private static Abdera abdera;
    private static final String URL = "http://localhost:8080";
    private static final String rootFolder = "testfolder";

    public static void main(String[] args) throws Exception {
        abdera = new Abdera();
        abdera.getFactory().registerExtension((ExtensionFactory)new CMISExtensionFactory());
        AbderaClient client = new AbderaClient(abdera);
        client.setMaxConnectionsPerHost(100);
        client.addCredentials(URL, null, "basic", (Credentials)new UsernamePasswordCredentials("admin", "admin"));
        String rootId = BulkCreateAndQuerySystemTest.createFolder(client, "http://localhost:8080/alfresco/service/cmis/p/children", rootFolder);
        for (int i = 0; i < 10000; ++i) {
            BulkCreateAndQuerySystemTest.createFolder(client, "http://localhost:8080/alfresco/service/cmis/p/testfolder/children", "folder_" + i);
            BulkCreateAndQuerySystemTest.findFolder(client, rootId, "folder_" + i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findFolder(AbderaClient client, String inFolderId, String name) {
        block7: {
            StringRequestEntity requestEntity;
            System.out.println("querying for " + name + " in " + inFolderId);
            String query = "<query xmlns=\"http://docs.oasis-open.org/ns/cmis/core/200908/\">\n<statement>SELECT cmis:Name, cmis:ObjectId FROM cmis:folder WHERE cmis:Name='" + name + "' AND IN_FOLDER('" + inFolderId + "')</statement>\n" + "<pageSize>100</pageSize>\n" + "<skipCount>0</skipCount>\n" + "</query>";
            try {
                requestEntity = new StringRequestEntity(query, "application/cmisquery+xml", "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            ClientResponse response = client.post("http://localhost:8080/alfresco/service/cmis/queries", (RequestEntity)requestEntity);
            try {
                if (response.getType() == Response.ResponseType.SUCCESS) {
                    Document feed = response.getDocument();
                    List entries = ((Feed)feed.getRoot()).getEntries();
                    for (Entry entry : entries) {
                        System.out.println("received query result with name " + entry.getTitle());
                    }
                    break block7;
                }
                throw new RuntimeException(response.getStatusText());
            }
            finally {
                response.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String createFolder(AbderaClient client, String parent, String name) throws Exception {
        Entry entry = abdera.newEntry();
        entry.setTitle(name);
        entry.setSummary("Summary...");
        CMISObject cmisObject = (CMISObject)entry.addExtension(CMISConstants.OBJECT);
        CMISProperties properties = (CMISProperties)cmisObject.addExtension(CMISConstants.PROPERTIES);
        CMISProperty property = (CMISProperty)properties.addExtension(CMISConstants.ID_PROPERTY);
        property.setAttributeValue(CMISConstants.PROPERTY_ID, "cmis:objectTypeId");
        Element value = property.addExtension(CMISConstants.PROPERTY_VALUE);
        value.setText("cmis:folder");
        ClientResponse resp = client.post(parent, (Base)entry);
        try {
            if (resp.getType() != Response.ResponseType.SUCCESS) {
                BulkCreateAndQuerySystemTest.printError(resp);
                throw new RuntimeException(resp.getStatusText());
            }
            System.out.println("Created folder " + name);
            Document entryDoc = resp.getDocument();
            Entry root = (Entry)entryDoc.getRoot();
            CMISObject object = (CMISObject)root.getExtension(CMISConstants.OBJECT);
            CMISProperties p = object.getProperties();
            String string = p.find("cmis:objectId").getStringValue();
            return string;
        }
        finally {
            resp.release();
        }
    }

    private static void printError(ClientResponse resp) {
        try {
            InputStream inputStream = resp.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String line = reader.readLine();
            while (line != null) {
                System.out.println(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

